/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import net.risesoft.controller.dto.EmailFolderDTO;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.EmailFolderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="standardEmailFolderController")
@RequestMapping(value={"/api/standard/emailFolder"})
public class EmailFolderController {
    @Autowired
    private EmailFolderService emailFolderService;

    @PostMapping
    public Y9Result<Object> save(String originFolderName, String newFolderName) {
        this.emailFolderService.save(originFolderName, newFolderName);
        return Y9Result.success();
    }

    @DeleteMapping
    public Y9Result<Object> delete(String folder) {
        this.emailFolderService.delete(folder);
        return Y9Result.success();
    }

    @GetMapping(value={"/defaultList"})
    public Y9Result<List<EmailFolderDTO>> defaultList() {
        List<EmailFolderDTO> emailFolderList = this.emailFolderService.getDefaultFolderList();
        return Y9Result.success(emailFolderList);
    }

    @GetMapping(value={"/customList"})
    public Y9Result<List<EmailFolderDTO>> customList() throws MessagingException {
        List<EmailFolderDTO> emailFolderList = this.emailFolderService.list();
        return Y9Result.success(emailFolderList);
    }

    @GetMapping(value={"/allList"})
    public Y9Result<Map<String, Object>> list() throws MessagingException {
        List<EmailFolderDTO> customFolderList = this.emailFolderService.list();
        List<EmailFolderDTO> defaultFolderList = this.emailFolderService.getDefaultFolderList();
        HashMap<String, List<EmailFolderDTO>> data = new HashMap<String, List<EmailFolderDTO>>();
        data.put("customFolderList", customFolderList);
        data.put("defaultFolderList", defaultFolderList);
        return Y9Result.success(data);
    }
}

