/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api;

import dm.jdbc.util.StringUtil;
import java.util.List;
import net.risesoft.controller.dto.EmailDTO;
import net.risesoft.james.service.JamesUserService;
import net.risesoft.model.platform.Person;
import net.risesoft.model.user.UserInfo;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.EmailAttachmentService;
import net.risesoft.service.EmailService;
import net.risesoft.support.DefaultFolder;
import net.risesoft.support.EmailThreadLocalHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import y9.client.rest.platform.org.PersonApiClient;

@RestController(value="Standard4EmailApiImpl")
@RequestMapping(value={"/services/rest/standardEmail"}, produces={"application/json"})
public class StandardEmailApiImpl {
    @Autowired
    EmailService emailService;
    @Autowired
    PersonApiClient personManager;
    @Autowired
    JamesUserService jamesUserService;
    @Autowired
    private EmailAttachmentService emailAttachmentService;

    @Transactional
    @PostMapping(value={"/send"}, consumes={"multipart/form-data"})
    public Y9Result<Object> send(@RequestParam(value="userId") String userId, @RequestParam(value="tenantId") String tenantId, @RequestParam(value="subject") String subject, @RequestParam(value="content") String content, @RequestParam(value="fromEmail", required=false) String fromEmail, @RequestParam(value="toEmail") List<String> toEmail, @RequestPart(value="file") MultipartFile file) throws Exception {
        Person person = (Person)this.personManager.get(tenantId, userId).getData();
        Y9LoginUserHolder.setPerson((Person)person);
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        EmailDTO email = new EmailDTO();
        email.setSubject(subject);
        email.setRichText(content);
        email.setText(content);
        email.setToEmailAddressList(toEmail);
        if (StringUtil.isEmpty((String)fromEmail)) {
            EmailThreadLocalHolder.setEmailAddress(this.jamesUserService.getEmailAddressByPersonId(person.getId()));
            email.setFrom(EmailThreadLocalHolder.getEmailAddress());
        } else {
            EmailThreadLocalHolder.setEmailAddress(fromEmail);
            email.setFrom(fromEmail);
        }
        String messageId = this.emailService.save(email);
        this.emailAttachmentService.addAttachment(DefaultFolder.DRAFTS.getName(), messageId, file);
        this.emailService.send(messageId);
        return Y9Result.successMsg((String)"\u53d1\u9001\u6210\u529f");
    }
}

