/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.security.service.impl;

import java.util.List;
import net.risedata.jdbc.factory.ObjectBuilderFactory;
import net.risedata.jdbc.service.impl.AutomaticCrudService;
import net.risesoft.exceptions.ServiceOperationException;
import net.risesoft.security.dao.RoleDao;
import net.risesoft.security.model.Role;
import net.risesoft.security.model.RoleUserLink;
import net.risesoft.security.service.RoleLinkService;
import net.risesoft.security.service.RoleService;
import net.risesoft.util.AutoIdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RoleServiceImpl
extends AutomaticCrudService<Role, String>
implements RoleService {
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    public static final String ADMIN_ID = "1";
    @Autowired
    RoleDao roleDao;
    @Autowired
    RoleLinkService roleLinkService;

    @Override
    public void saveRole(Role role) {
        if (this.roleDao.hasName(role.getName(), role.getId() == null ? "NULL" : role.getId()) > 0) {
            throw new ServiceOperationException("\u89d2\u8272\u540d:" + role.getName() + "\u5df2\u5b58\u5728!");
        }
        if (role.getId() == null) {
            role.setId(AutoIdUtil.getRandomId26());
            this.insert(role);
        } else if (this.findById(role.getId()) == null) {
            this.insert(role);
        } else {
            this.updateById(role);
        }
    }

    @Override
    public void deleteByRoleId(String id) {
        if (ADMIN_ID.equals(id)) {
            throw new ServiceOperationException("\u7ba1\u7406\u5458\u89d2\u8272\u4e0d\u80fd\u5220\u9664");
        }
        this.deleteById(id);
        this.roleLinkService.delete((RoleUserLink)ObjectBuilderFactory.builder(RoleUserLink.class).builder("roleId", (Object)id));
    }

    @Override
    public List<Role> getRolesByUser(String id) {
        return this.roleDao.getRolesByUser(id);
    }

    @Override
    public Role findById(String id) {
        return (Role)this.getOne(id);
    }

    @Override
    public Integer hasAdminRole() {
        return this.roleDao.hasAdminRole();
    }
}

