/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import cn.hutool.core.codec.Base64;
import javax.validation.Valid;
import net.risedata.jdbc.commons.LPage;
import net.risedata.jdbc.search.LPageable;
import net.risesoft.pojo.Y9Result;
import net.risesoft.security.SecurityManager;
import net.risesoft.security.model.DataUser;
import net.risesoft.security.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rest/user"})
public class UserController {
    @Autowired
    private UserService userService;
    @Autowired
    SecurityManager securityManager;

    @RequestMapping(value={"searchForPage"})
    public Y9Result<LPage<DataUser>> searchForPage(DataUser betaUser, LPageable lPageable) {
        return Y9Result.success(this.userService.searchForPage(betaUser, lPageable));
    }

    @PostMapping(value={"createUser"})
    public Y9Result<Object> createUser(@Valid @RequestBody DataUser dataUser) {
        dataUser.setPassword(Base64.decodeStr((CharSequence)dataUser.getPassword()));
        return Y9Result.success((Object)this.userService.createUser(dataUser));
    }

    @PostMapping(value={"updateUserInfo"})
    public Y9Result<Object> updateUserInfo(@Valid DataUser betaUser) {
        return Y9Result.success((Object)this.userService.updateInfoById(betaUser));
    }

    @PostMapping(value={"updatePassword"})
    public Y9Result<Object> updatePassword(@RequestParam(required=true) String id, @RequestParam(required=true) String password) {
        this.userService.updatePassword(id, Base64.decodeStr((CharSequence)password));
        return Y9Result.success((Object)1);
    }

    @PostMapping(value={"deleteUser"})
    public Y9Result<Object> deleteUser(@RequestParam(required=true) String id) {
        return Y9Result.success((Object)this.userService.deleteUser(id));
    }

    @GetMapping(value={"getUser"})
    public Y9Result<Object> getUser(@RequestParam(required=true) String id) {
        DataUser dataUser = this.userService.findOne(id);
        dataUser.setPassword("");
        return Y9Result.success((Object)dataUser);
    }
}

