/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.watch;

import cn.hutool.http.HttpUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;
import net.risedata.register.model.WatchProperties;
import net.risesoft.api.persistence.iservice.IServiceService;
import net.risesoft.api.persistence.model.IServiceInstanceModel;
import net.risesoft.api.watch.WatchManager;
import org.apache.commons.lang3.StringUtils;

public class CheckStatusTask
implements TimerTask {
    private String instanceId;
    private int errorCout = 0;
    private int successCount = 0;
    private String myInstanceId;
    private IServiceService iServiceService;

    public CheckStatusTask(String instanceId, String myInstanceId, IServiceService iServiceService) {
        this.instanceId = instanceId;
        this.myInstanceId = myInstanceId;
        this.iServiceService = iServiceService;
    }

    public static boolean check(IServiceInstanceModel iServiceInstance) {
        String checkUrl = CheckStatusTask.createCheckUrl(iServiceInstance);
        String retStr = HttpUtil.get((String)checkUrl, (int)iServiceInstance.getWatchInfo().getTimeOut());
        if (WatchManager.LOGGER.isDebugEnabled()) {
            WatchManager.LOGGER.debug(iServiceInstance.getInstanceId() + "check instance for url" + retStr);
        }
        Boolean res = !StringUtils.isEmpty((CharSequence)iServiceInstance.getWatchInfo().getWatchUrl()) ? (!StringUtils.isEmpty((CharSequence)iServiceInstance.getWatchInfo().getSuccessRet()) ? Boolean.valueOf(iServiceInstance.getWatchInfo().getSuccessRet().equals(retStr)) : Boolean.valueOf(true)) : Boolean.valueOf(retStr);
        return res;
    }

    public void run(Timeout timeout) throws Exception {
        if (!WatchManager.hasTask(this, this.instanceId)) {
            return;
        }
        IServiceInstanceModel iServiceInstance = this.iServiceService.findWatchById(this.instanceId);
        if (iServiceInstance == null || !iServiceInstance.getWatchInfo().isWatch()) {
            WatchManager.removeTask(this.instanceId, this);
            return;
        }
        try {
            Boolean res = CheckStatusTask.check(iServiceInstance);
            if (res.booleanValue()) {
                ++this.successCount;
                this.errorCout = 0;
            } else {
                ++this.errorCout;
                this.successCount = 0;
            }
        }
        catch (Exception e) {
            ++this.errorCout;
            this.successCount = 0;
        }
        if (iServiceInstance.getStatus() == 0) {
            if (this.errorCout >= iServiceInstance.getWatchInfo().getFail()) {
                this.iServiceService.setStatus(iServiceInstance.getInstanceId(), 2);
            }
        } else if (iServiceInstance.getStatus() == 2 && iServiceInstance.getWatchInfo().getSuccess() > 0 && this.successCount >= iServiceInstance.getWatchInfo().getSuccess()) {
            this.iServiceService.setStatus(iServiceInstance.getInstanceId(), 0);
        }
        if (iServiceInstance.getStatus() != 1) {
            timeout.timer().newTimeout((TimerTask)this, (long)(iServiceInstance.getWatchInfo().getTime() * (this.errorCout > 3 ? (this.errorCout > 10 ? 10 : this.errorCout) : 1)), TimeUnit.MILLISECONDS);
        }
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public int getErrorCout() {
        return this.errorCout;
    }

    public int getSuccessCount() {
        return this.successCount;
    }

    public static String createCheckUrl(IServiceInstanceModel watchInfo) {
        WatchProperties info = watchInfo.getWatchInfo();
        StringBuilder urlBuild = new StringBuilder();
        urlBuild.append(watchInfo.getSecure() ? "https://" : "http://");
        urlBuild.append(watchInfo.getHost()).append(":").append(watchInfo.getPort()).append("/").append(watchInfo.getWatchInfo().getBaseContext()).append(StringUtils.isEmpty((CharSequence)info.getWatchUrl()) ? "REGISTER/WATCH" : watchInfo.getWatchInfo().getWatchUrl()).append("/CHECK");
        return urlBuild.toString();
    }

    public String toString() {
        return "CheckStatusTask{instanceId='" + this.instanceId + "', errorCout=" + this.errorCout + ", successCount=" + this.successCount + "}";
    }
}

