/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.utils;

import net.risesoft.api.utils.CommitFunction;

public class BatchOperation<T> {
    private int count;
    private T value;
    private CommitFunction commitFunction;

    public BatchOperation(int count, T value, CommitFunction<T> commitFunction) {
        this.count = count;
        this.value = value;
        this.commitFunction = commitFunction;
    }

    public BatchOperation(int count, T value) {
        this.count = count;
        this.value = value;
    }

    public synchronized void commit(CommitFunction<T> commitFunction) {
        --this.count;
        commitFunction.commit(this.value);
        if (this.count == 0) {
            this.commitFunction.commit(this.value);
        }
    }

    public synchronized void onCommit(CommitFunction<T> commitFunction) {
        this.commitFunction = commitFunction;
        if (this.count == 0) {
            this.commitFunction.commit(this.value);
        }
    }
}

