/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.persistence.job.impl;

import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.builder.OperationBuilder;
import net.risedata.jdbc.commons.LPage;
import net.risedata.jdbc.factory.OperationBuilderFactory;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.operation.impl.CustomOperation;
import net.risedata.jdbc.search.LPageable;
import net.risedata.jdbc.service.impl.AutomaticCrudService;
import net.risedata.register.service.IServiceInstanceFactory;
import net.risesoft.api.job.JobContext;
import net.risesoft.api.job.JobTask;
import net.risesoft.api.job.TaskExecutorService;
import net.risesoft.api.job.TaskManager;
import net.risesoft.api.persistence.dao.job.JobDao;
import net.risesoft.api.persistence.dao.job.JobLogDao;
import net.risesoft.api.persistence.job.JobChangeService;
import net.risesoft.api.persistence.job.JobLogService;
import net.risesoft.api.persistence.job.JobService;
import net.risesoft.api.persistence.model.job.Job;
import net.risesoft.api.persistence.model.job.JobLog;
import net.risesoft.api.utils.SqlUtils;
import net.risesoft.security.ConcurrentSecurity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobServiceImpl
extends AutomaticCrudService<Job, Integer>
implements JobService {
    @Autowired
    JobDao jobDao;
    @Autowired
    JobLogDao jobLogDao;
    @Autowired
    IServiceInstanceFactory iServiceInstanceFactory;
    @Autowired(required=false)
    TaskManager taskManager;
    @Autowired
    JobChangeService jobChangeService;
    @Autowired
    JdbcTemplate jt;
    @Autowired
    JobLogService jobLogService;
    @Autowired(required=false)
    TaskExecutorService taskExecutorService;

    @Override
    @Transactional
    public boolean saveJob(Job job) {
        job.setUpdateTime(System.currentTimeMillis());
        if (job.getDispatchType().equals("cron")) {
            try {
                CronExpression.parse((String)job.getSpeed()).next((Temporal)LocalDateTime.now());
            }
            catch (Exception e) {
                throw new RuntimeException("cron \u8868\u8fbe\u5f0f\u9519\u8bef!");
            }
        }
        if (job.getId() == null || job.getId() == 0) {
            job.setDispatchServer("");
            job.setCreateDate(new Date());
            job.setId(this.getMaxId());
            if (job.getStatus() == 1) {
                job.setDispatchServer(this.iServiceInstanceFactory.getIsntance().getInstanceId());
            }
            this.insert(job);
            if (job.getStatus() == 1) {
                this.taskManager.addTask(job);
            }
            return true;
        }
        this.updateById(job);
        if (job.getStatus() == 1 && this.taskManager != null) {
            this.jobChangeService.insertChange(job.getId());
            this.taskManager.pushJobChange(job.getId());
        }
        return true;
    }

    private Integer getMaxId() {
        Integer maxId = this.jobDao.getMaxId();
        return maxId == null ? 1 : maxId + 1;
    }

    @Override
    public Job findByJobId(Integer jobId) {
        return this.jobDao.findById(jobId);
    }

    @Override
    public boolean deleteByJobId(Integer id) {
        this.jobLogDao.deleteJobLog(id);
        return this.deleteById(id) > 0;
    }

    @Override
    public List<Job> findDispatchJob(String watchServer, String environment, String serviceId) {
        return this.jobDao.findWatch(watchServer, environment, serviceId);
    }

    @Override
    public LPage<Job> search(Job job, LPageable pageable, ConcurrentSecurity jurisdiction) {
        return this.searchForPage(job, pageable, null, (Map)JobServiceImpl.createBuilder("serviceId", jurisdiction));
    }

    public static OperationBuilder createBuilder(String field, ConcurrentSecurity jurisdiction) {
        return OperationBuilderFactory.builder((String)field, (Operation)new CustomOperation(where -> {
            if (jurisdiction.getJobTypes().isEmpty()) {
                return false;
            }
            where.append((CharSequence)"SERVICE_JOB_TYPE in  ");
            SqlUtils.appendIn(jurisdiction.getJobTypes(), where);
            return true;
        }));
    }

    @Override
    public List<Job> findMiss(String instanceId, Integer[] ids, Map<Integer, JobTask> jobTask) {
        if (ids.length == 0) {
            return this.jobDao.findMiss(instanceId);
        }
        if (ids.length > 999) {
            List<Integer> jobIds = this.jobDao.findJobIds(instanceId);
            ArrayList<Job> jobs = new ArrayList<Job>();
            for (Integer jobId : jobIds) {
                if (jobTask.containsKey(jobId)) continue;
                jobs.add(this.jobDao.findById(jobId));
            }
            return jobs;
        }
        return this.jobDao.findMiss(instanceId, ids);
    }

    @Override
    public void setStatus(Integer id, int status) {
        this.jobDao.updateStatus(id, status);
        if (status == 1 && this.taskManager != null) {
            this.jobChangeService.insertChange(id);
            this.taskManager.pushJobChange(id);
        }
    }

    @Override
    public List<Job> findWatch(String instanceId, String environment, String serviceId) {
        return this.jobDao.findWatch(instanceId, environment, serviceId);
    }

    @Override
    public boolean updateWatch(Integer id, String watchServer, String ovlInstanceId) {
        return this.jobDao.updateWatch(id, watchServer, ovlInstanceId) > 0;
    }

    @Override
    public void updateNoWatch(Integer[] ids) {
        if (ids == null || ids.length == 0) {
            return;
        }
        if (ids.length > 999) {
            int split = ids.length % 999 == 0 ? ids.length / 999 : ids.length / 999 + 1;
            for (int i = 0; i < split; ++i) {
                this.jobDao.updateNoWatch(this.iServiceInstanceFactory.getIsntance().getInstanceId(), Arrays.copyOfRange(ids, i * 999, i == split - 1 ? ids.length : (i + 1) * 999), this.iServiceInstanceFactory.getIsntance().getServiceId(), this.iServiceInstanceFactory.getIsntance().getEnvironment());
            }
            return;
        }
        this.jobDao.updateNoWatch(this.iServiceInstanceFactory.getIsntance().getInstanceId(), ids, this.iServiceInstanceFactory.getIsntance().getServiceId(), this.iServiceInstanceFactory.getIsntance().getEnvironment());
    }

    @Override
    public Job findByJobIdAndUse(Integer id) {
        return this.jobDao.findByJobIdAndUse(this.iServiceInstanceFactory.getIsntance().getInstanceId(), id);
    }

    @Override
    public boolean hasTask(Integer id) {
        return this.jobDao.hasTask(this.iServiceInstanceFactory.getIsntance().getInstanceId(), id) > 0;
    }

    @Override
    public List<Map<String, Object>> searchJob(Job job, ConcurrentSecurity securityJurisdiction) {
        return this.getSearchExecutor().searchForList((Object)job, "ID,JOB_NAME", (Map)JobServiceImpl.createBuilder("dispatchServer", securityJurisdiction), null, false);
    }

    @Override
    public Map<String, Object> getCount(String environment) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobCount", this.jobDao.getJobCount(environment));
        map.put("serviceCount", this.jobDao.getServiceCount(environment));
        map.put("logCount", this.jobLogService.getLogCount(environment));
        return map;
    }

    @Override
    public List<String> searchJobService(Job job, ConcurrentSecurity securityJurisdiction) {
        return this.getSearchExecutor().searchForList((Object)job, "distinct SERVICE_ID", (Map)JobServiceImpl.createBuilder("dispatchServer", securityJurisdiction), null, false, String.class);
    }

    @Override
    public int searchCountByJobType(String name, String environment) {
        return this.jobDao.searchCountByJobType(name, environment);
    }

    @Override
    public boolean killAwaitJob(Integer jobId) {
        return this.jobLogService.killAwaitJob(jobId);
    }

    @Override
    public boolean endJob(Integer jobId, String jobLogId, String result, String msg, Integer status) {
        Job job = this.jobDao.findById(jobId);
        if (job != null) {
            JobLog jobLog = this.jobLogService.findById(jobLogId);
            if (jobLog != null) {
                if (!job.getDispatchServer().equals(this.iServiceInstanceFactory.getIsntance().getInstanceId())) {
                    this.updateWatch(jobId, this.iServiceInstanceFactory.getIsntance().getInstanceId(), job.getDispatchServer());
                }
                JobContext jobContext = new JobContext(new HashMap<String, Object>());
                jobContext.setChildrenJob(false);
                this.taskExecutorService.appendLog(jobLogId, "rpc\u8fde\u63a5\u5f02\u5e38\u4e3b\u52a8\u7ed3\u675f\u4efb\u52a1!");
                this.taskExecutorService.endJob(job, jobLog, status, msg, result, jobContext);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public List<Job> findJobsByServiceId(String serviceId, String environment) {
        return this.jobDao.findJobsByServiceId(serviceId, environment);
    }

    @Override
    public List<Job> searchJobByArgs(String args) {
        return this.jobDao.searchJobByArgs(args);
    }

    @Override
    public int findCountJobByArgs(String args) {
        return this.jobDao.findCountJobByArgs(args);
    }

    @Override
    public List<String> findArgsById(String id) {
        return Arrays.asList(this.jobDao.findArgsById(id).split(","));
    }

    @Override
    public Map<String, Integer> getNormalStateTaskNumber(List<Integer> logStatus, Long startTime, Long endTime, List<Integer> jobStatus) {
        Integer activeTaskCount = this.jobDao.getActiveTaskCountByTime(logStatus, startTime, endTime, jobStatus);
        Integer allCount = this.jobDao.getallJobCountByStatus(jobStatus);
        Integer notActiveCount = allCount - activeTaskCount;
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("active", activeTaskCount);
        result.put("notActive", notActiveCount);
        return result;
    }

    @Override
    public Job findByArgsAndTypeAndEnvironmentAndServiceId(String args, String type, String environment, String serviceId) {
        return this.jobDao.findByArgsAndTypeAndEnvironmentAndServiceId(args, type, environment, serviceId);
    }
}

