/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.persistence.job.impl;

import cn.hutool.core.date.DateUtil;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.builder.OperationBuilder;
import net.risedata.jdbc.commons.LPage;
import net.risedata.jdbc.factory.OperationBuilderFactory;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.operation.impl.CustomOperation;
import net.risedata.jdbc.operation.impl.InOperation;
import net.risedata.jdbc.operation.impl.SectionOperation;
import net.risedata.jdbc.search.LPageable;
import net.risedata.jdbc.service.impl.AutomaticCrudService;
import net.risedata.register.service.IServiceInstanceFactory;
import net.risedata.rpc.provide.config.Application;
import net.risesoft.api.job.TaskManager;
import net.risesoft.api.listener.ClientListener;
import net.risesoft.api.message.MessageService;
import net.risesoft.api.persistence.dao.job.JobLogDao;
import net.risesoft.api.persistence.job.JobInfoService;
import net.risesoft.api.persistence.job.JobLogService;
import net.risesoft.api.persistence.job.JobService;
import net.risesoft.api.persistence.model.job.Job;
import net.risesoft.api.persistence.model.job.JobLog;
import net.risesoft.api.utils.AutoIdUtil;
import net.risesoft.api.utils.SqlUtils;
import net.risesoft.exceptions.ServiceOperationException;
import net.risesoft.security.ConcurrentSecurity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.stereotype.Service;

@Service
public class JobLogServiceImpl
extends AutomaticCrudService<JobLog, String>
implements JobLogService {
    @Autowired
    JobLogDao jobLogDao;
    @Autowired
    JobInfoService jobInfoService;
    private static final int MAX_LOG = 1500;
    @Autowired
    IServiceInstanceFactory iServiceInstanceFactory;
    @Value(value="${beta.job.jobTimeOut:3600}")
    private Integer defaultTimeOut;
    @Autowired
    JobService jobService;
    @Autowired
    MessageService messageService;
    @Autowired
    TaskManager taskManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBlock(Integer jobId, int timeOut, String logId) {
        String string = jobId.toString().intern();
        synchronized (string) {
            if (timeOut > 0) {
                return this.jobLogDao.isBlock(jobId, System.currentTimeMillis() - (long)(timeOut * 1000), logId) > 0;
            }
            return this.jobLogDao.isBlock(jobId, logId) > 0;
        }
    }

    @Override
    public boolean saveLog(JobLog jobLog) {
        if (StringUtils.isEmpty((CharSequence)jobLog.getId())) {
            jobLog.setId(AutoIdUtil.getRandomId26());
            jobLog.setDispatchTime(System.currentTimeMillis());
            this.insert(jobLog);
        } else {
            this.updateById(jobLog);
        }
        return true;
    }

    @Override
    public boolean appendLog(String id, String logContext) {
        try {
            boolean result = this.jobLogDao.appendLog(id, DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + " : " + this.getMsg(logContext) + "\n") > 0;
            this.saveMsg(id, logContext, 1500);
            return result;
        }
        catch (Exception e) {
            Application.logger.error("job log error" + e.getMessage() + "log_Id:" + id);
            this.subLog(id);
            boolean result = this.jobLogDao.appendLog(id, DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + " : " + this.getMsg(logContext) + "\n") > 0;
            this.saveMsg(id, logContext, 1500);
            return result;
        }
    }

    private void subLog(String id) {
        String content = this.jobLogDao.findConsoleById(id);
        if (content.length() < 500) {
            return;
        }
        this.jobLogDao.updateLog(id, content.substring(0, 500) + "......\n" + content.substring(content.length() - 500, content.length()));
    }

    @Override
    public boolean updateStatus(String logId, Integer status, Integer ovlStatus) {
        return this.jobLogDao.updateStatus(logId, status, ovlStatus) > 0;
    }

    @Override
    public boolean updateStatus(String logId, Integer status) {
        return this.jobLogDao.updateStatus(logId, status) > 0;
    }

    @Override
    public JobLog pollJob(Integer jobId, int timeOut) {
        if (timeOut < 1) {
            return this.jobLogDao.pollJob(jobId);
        }
        return this.jobLogDao.pollJob(jobId, System.currentTimeMillis() - (long)(timeOut * 1000));
    }

    @Override
    public void endJob(String id, int success, String msg, String result, String environment) {
        try {
            this.jobLogDao.endJob(id, success, DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + " : " + this.getMsg(msg), System.currentTimeMillis(), this.getMsg(result));
            this.saveMsg(id, msg, 1500);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.subLog(id);
            this.jobLogDao.endJob(id, success, DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + " : \u4fdd\u5b58\u4efb\u52a1\u7ed3\u675f\u65e5\u5fd7\u65f6\u51fa\u9519\u5f02\u5e38\u4fe1\u606f" + e.getMessage() + "\u5bf9\u5e94\u6d88\u606f:" + this.getMsg(msg) + "....", System.currentTimeMillis(), "\u8fd4\u56de\u7ed3\u679c:" + result.substring(0, result.length() > 1500 ? 1500 : result.length()) + "....");
            this.saveMsg(id, msg, 1500);
        }
        this.addInfo(success, environment);
    }

    private void addInfo(int status, String environment) {
        switch (status) {
            case 1: {
                this.jobInfoService.addSuccess(environment);
                break;
            }
            case 2: {
                this.jobInfoService.addError(environment);
                break;
            }
        }
    }

    @Override
    public void appendSource(String id, String source, String msg) {
        this.jobLogDao.appendSource(id, source + "|", DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + " : " + this.getMsg(msg) + "\n");
        this.saveMsg(id, msg, 1500);
    }

    private void saveMsg(String id, String msg, int start) {
        if (!StringUtils.isEmpty((CharSequence)msg) && msg.length() > start) {
            int end = 0;
            while (msg.length() > start) {
                end = start + 1500;
                if (end > msg.length()) {
                    end = msg.length();
                }
                this.jobLogDao.appendLog(id, msg.substring(start, end));
                start = end;
            }
        }
    }

    @Override
    public JobLog findDownJob(Integer id, List<String> logs) {
        if (logs == null || logs.size() == 0) {
            return this.jobLogDao.findDownJob(id);
        }
        return this.jobLogDao.findDownJob(id, logs);
    }

    @Override
    public JobLog findById(String id) {
        return this.jobLogDao.findById(id);
    }

    @Override
    public LPage<Map<String, Object>> search(JobLog job, LPageable page, ConcurrentSecurity securityJurisdiction, String jobType, Integer[] jobIds) {
        OperationBuilder operationBuilder = OperationBuilderFactory.builder((String)"id", (Operation)new CustomOperation(where -> {
            List jobTypes = securityJurisdiction.getJobTypes();
            if (StringUtils.isEmpty((CharSequence)jobType)) {
                if (jobTypes.isEmpty()) {
                    return false;
                }
                where.append((CharSequence)"JOB_ID in (select ID from Y9_DATASERVICE_JOB where SERVICE_JOB_TYPE in ");
                SqlUtils.appendIn(jobTypes, where);
                where.append((CharSequence)")");
                return true;
            }
            if (jobTypes.isEmpty() || jobTypes.indexOf(jobType) != -1) {
                where.append((CharSequence)"JOB_ID in (select ID from Y9_DATASERVICE_JOB where SERVICE_JOB_TYPE=?)");
                where.add((Object)jobType);
                return true;
            }
            throw new ServiceOperationException("no security");
        })).builder("childJobId", (Operation)new CustomOperation(where -> {
            boolean flag = false;
            if (!StringUtils.isEmpty((CharSequence)job.getJobName())) {
                where.append((CharSequence)"job_id in  (select id from Y9_DATASERVICE_JOB where job_name like ?)");
                where.add((Object)("%" + job.getJobName() + "%"));
                flag = true;
            }
            return flag;
        }));
        if (jobIds != null && jobIds.length > 0) {
            operationBuilder.builder("jobId", (Operation)new InOperation(true, (Object)jobIds));
        }
        return this.getSearchExecutor().searchForPage((Object)job, "ID,DISPATCH_SERVER,DISPATCH_TIME,END_TIME,JOB_ID,RESULT,STATUS,DISPATCH_SOURCE,(select job_name from Y9_DATASERVICE_JOB where id = job_id) JOB_NAME,(select SERVICE_JOB_TYPE from Y9_DATASERVICE_JOB where id = job_id) JOB_TYPE", page, (Map)operationBuilder);
    }

    @Override
    public String findConsoleById(String id) {
        return this.jobLogDao.findConsoleById(id);
    }

    @Override
    public void clearLog(Date time) {
        this.jobLogDao.clearLog(time.getTime());
    }

    @Override
    public void clearTimeOutJob() {
        Date date = new Date();
        HashSet<Integer> ids = new HashSet<Integer>();
        List<Integer> clearEdJobIds = this.jobLogDao.searchClearTimeOutJob(System.currentTimeMillis(), this.iServiceInstanceFactory.getIsntance().getInstanceId());
        if (this.jobLogDao.clearTimeOutJob(DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss") + " : \u4efb\u52a1\u8d85\u65f6\u7ed3\u675f\u4efb\u52a1! \n", date.getTime(), date.getTime(), this.iServiceInstanceFactory.getIsntance().getInstanceId()).intValue() == clearEdJobIds.size()) {
            ids.addAll(clearEdJobIds);
        }
        this.jobLogDao.clearTimeOutJobAndAwait(DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss") + " : \u4efb\u52a1\u8d85\u65f6\u7ed3\u675f\u4efb\u52a1! \n", date.getTime(), date.getTime(), this.iServiceInstanceFactory.getIsntance().getInstanceId());
        List<Integer> ids2 = this.jobLogDao.searchClearDefaultTimeOut(System.currentTimeMillis() - (long)(this.defaultTimeOut * 1000), this.iServiceInstanceFactory.getIsntance().getInstanceId());
        if (this.jobLogDao.clearDefaultTimeOut(DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss") + " : \u4efb\u52a1\u8d85\u8fc7\u9ed8\u8ba4\u65f6\u95f4\u7ed3\u675f\u4efb\u52a1! \n", date.getTime() - (long)(this.defaultTimeOut * 1000), date, this.iServiceInstanceFactory.getIsntance().getInstanceId()).intValue() == ids2.size()) {
            ids.addAll(ids2);
        }
        for (Integer jobid : ids) {
            System.out.println("clear---" + jobid);
            Job tmp = this.jobService.findByJobId(jobid);
            if (tmp == null) continue;
            this.messageService.onJobError(tmp);
            this.taskManager.endJob(tmp, jobid);
        }
    }

    @Override
    public Integer getLogCount(String environment) {
        return this.jobLogDao.getLogCount(environment);
    }

    @Override
    public List<JobLog> findDownJobs(Integer id, List<String> logs) {
        if (logs == null || logs.size() == 0) {
            return this.jobLogDao.findDownJobs(id);
        }
        return this.jobLogDao.findDownJobs(id, logs);
    }

    @Override
    public ServiceInstance getRunableMinInstance(List<ServiceInstance> instanceIds) {
        if (instanceIds.size() == 1) {
            return instanceIds.get(0);
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<CallSite> index = new ArrayList<CallSite>();
        boolean isAppend = false;
        for (int i = 0; i < instanceIds.size(); ++i) {
            if (ClientListener.getConnection(instanceIds.get(i).getInstanceId()) == null) continue;
            if (isAppend) {
                sql.append(",");
            }
            sql.append("(select count(*) $indexKey,max(DISPATCH_TIME) $TIME from Y9_DATASERVICE_JOB_log where status=0 and  dispatch_source like '%$instanceId|') as subquery".replace("$indexKey", "INDEX_" + i).replace("$TIME", "TIME_INDEX_" + i).replace("$instanceId", instanceIds.get(i).getInstanceId()));
            isAppend = true;
            index.add((CallSite)((Object)("INDEX_" + i)));
        }
        Map<String, Object> sizeMap = this.jobLogDao.findRunableMinInstance(sql.toString());
        int min = 9999;
        int minIndex = 0;
        int tempSize = 0;
        long tempTime = 0L;
        long minTime = 0L;
        for (int i = 0; i < index.size(); ++i) {
            Long querSize = (Long)sizeMap.get(index.get(i));
            tempSize = querSize.intValue();
            long l = tempTime = sizeMap.get("TIME_" + (String)index.get(i)) == null ? Long.MAX_VALUE : ((BigDecimal)sizeMap.get("TIME_" + (String)index.get(i))).longValue();
            if (min <= tempSize && (min != tempSize || minTime <= tempTime)) continue;
            minIndex = i;
            min = tempSize;
            minTime = tempTime;
        }
        return instanceIds.get(minIndex);
    }

    @Override
    public boolean killAwaitJob(Integer jobId) {
        return this.jobLogDao.deleteAwaitJobLog(jobId) > 0;
    }

    @Override
    public LPage<Map<String, Object>> searchByGroup(Date startDate, Date endDate, String environment, LPageable page, String jobName, ConcurrentSecurity jurisdiction) {
        JobLog jobLog = new JobLog();
        jobLog.setStatus(2);
        jobLog.setEnvironment(environment);
        return this.getSearchExecutor().searchForPage((Object)jobLog, "(select job_name from Y9_DATASERVICE_JOB as a2 where a2.id = JobLog.job_id) job_name,job_id,max(dispatch_time) dispatch_time,count(*) count", page, (Map)this.getOperationBuilder(startDate, endDate, jobName, jurisdiction.getJobTypes()), null, true);
    }

    private OperationBuilder getOperationBuilder(Date startDate, Date endDate, String jobName, List<String> jobTypes) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String eDate = sdf.format(endDate) + " 23:59:59";
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            endDate = sdf2.parse(eDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return OperationBuilderFactory.builder((String)"dispatchTime", (Operation)new SectionOperation((Object)startDate.getTime(), (Object)endDate.getTime()), (String)"id", (Operation)new CustomOperation(where -> {
            where.append((CharSequence)" JOB_ID in (select ID from Y9_DATASERVICE_JOB where SERVICE_JOB_TYPE in ");
            SqlUtils.appendIn(jobTypes, where);
            if (!StringUtils.isEmpty((CharSequence)jobName)) {
                where.append((CharSequence)" and job_name like ?)");
                where.add((Object)("%" + jobName + "%"));
            } else {
                where.append((CharSequence)")");
            }
            where.append((CharSequence)" GROUP BY JOB_ID  ");
            return true;
        }, 99));
    }

    @Override
    public List<Map<String, Object>> searchByGroupLog(Date startDate, Date endDate, String environment, String jobName) {
        JobLog jobLog = new JobLog();
        jobLog.setStatus(2);
        jobLog.setEnvironment(environment);
        return this.getSearchExecutor().searchForList((Object)jobLog, "(select job_name from Y9_DATASERVICE_JOB where id = JobLog.job_id) job_name,(select status from Y9_DATASERVICE_JOB_log where id= (select max(id) from Y9_DATASERVICE_JOB_log a where a.job_id=JobLog.job_id )) job_end_status,job_id,max(dispatch_time) dispatch_time,count(*) count,(select log_console from Y9_DATASERVICE_JOB_log where id= (select max(id) from Y9_DATASERVICE_JOB_log a where a.job_id=JobLog.job_id and a.status =2)  ) log_console", (Map)this.getOperationBuilder(startDate, endDate, jobName, null), null);
    }

    private String getMsg(String msg) {
        if (msg == null) {
            return "NULL";
        }
        if (msg.length() > 1500) {
            return msg.substring(0, 1500);
        }
        return msg;
    }

    @Override
    public Integer getExecutedCountByStatusAndTime(List<Integer> statusList, long start, long end, List<String> jobTypes) {
        return this.jobLogDao.getExecutedCountByStatusAndTime(statusList, start, end, jobTypes);
    }

    @Override
    public List<Map<String, Object>> getExecutedCountGroupByDispatchTime(List<Integer> statusList, long start, long end, List<String> jobTypes) {
        return this.jobLogDao.getExecutedCountGroupByDispatchTime(statusList, start, end, jobTypes);
    }

    @Override
    public List<Map<String, Object>> getSchedulingInfo(List<Integer> statuslist, Long startTime, Long endTime, String environment, List<String> jobTypes) {
        return this.jobLogDao.getSchedulingInfo(statuslist, startTime, endTime, environment, jobTypes);
    }

    @Override
    public List<Map<String, Object>> getLogGroupInfo(List<Integer> statuslist, Long startTime, Long endTime, List<String> jobTypes) {
        return this.jobLogDao.getLogGroupInfo(statuslist, startTime, endTime, jobTypes);
    }
}

