/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.persistence.config.impl;

import java.util.Date;
import java.util.Map;
import net.risedata.jdbc.commons.LPage;
import net.risedata.jdbc.search.LPageable;
import net.risedata.jdbc.service.impl.AutomaticCrudService;
import net.risesoft.api.persistence.config.ConfigHisService;
import net.risesoft.api.persistence.dao.ConfigHisDao;
import net.risesoft.api.persistence.log.LogService;
import net.risesoft.api.persistence.model.config.Config;
import net.risesoft.api.persistence.model.config.ConfigHis;
import net.risesoft.api.utils.AutoIdUtil;
import net.risesoft.security.SecurityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class ConfigHisServiceImpl
extends AutomaticCrudService<ConfigHis, String>
implements ConfigHisService {
    @Autowired
    SecurityManager securityManager;
    @Autowired
    ConfigHisDao configHisDao;
    private static final long HIS_DAY_TIME = 31104000000L;
    @Autowired
    LogService logService;

    @Override
    public void saveConfig(Config config, String operation) {
        ConfigHis his = new ConfigHis();
        his.setId(AutoIdUtil.getRandomId26());
        his.setConfigId(config.getId());
        his.setContent(config.getContent());
        his.setName(config.getName());
        his.setUpdateTime(new Date());
        his.setType(config.getType());
        his.setOpName(this.securityManager.getConcurrentSecurity().getUser().getUserName());
        his.setEnvironment(config.getEnvironment());
        his.setGroup(config.getGroup());
        his.setOpType(operation);
        this.insert(his);
    }

    @Override
    public LPage<Map<String, Object>> search(ConfigHis config, LPageable pageable) {
        return this.getSearchExecutor().searchForPage((Object)config, "ID id,NAME name,TYPE config_type,GROUP_NAME config_group,ENVIRONMENT environment,UPDATETIME updateTime,OP_NAME opName ,OP_TYPE opType,CONFIG_ID configId", pageable);
    }

    @Override
    public void delConfigById(String id) {
        this.deleteById(id);
    }

    @Override
    public ConfigHis findOne(String id) {
        return (ConfigHis)this.getOne(id);
    }

    @Override
    @Scheduled(cron="0 0 0 * * ? ")
    public void clearHis() {
        this.configHisDao.clear(new Date(System.currentTimeMillis() - 31104000000L));
        this.logService.clear(new Date(System.currentTimeMillis() - 31104000000L));
    }
}

