/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.job.actions.dispatch;

import java.util.ArrayList;
import java.util.List;
import net.risesoft.api.exceptions.JobException;
import net.risesoft.api.job.actions.dispatch.DoResult;
import net.risesoft.api.job.actions.dispatch.executor.Result;
import net.risesoft.api.job.actions.dispatch.executor.ResultError;
import net.risesoft.api.job.actions.dispatch.executor.ResultSuccess;

public class CountResult
implements Result {
    private Result result;
    private List<ResultSuccess> successes = new ArrayList<ResultSuccess>();
    private List<ResultError> errors = new ArrayList<ResultError>();
    private int count;
    private DoResult doResult;
    private Object val;

    public CountResult() {
    }

    public CountResult(int count, DoResult doResult) {
        this.count = count;
        this.doResult = doResult;
        this.setResult(doResult.doResult(count--, null));
    }

    private void setResult(Result result) {
        this.result = result;
        CountResult lockObject = this;
        result.onSuccess(val -> {
            Object object = lockObject;
            synchronized (object) {
                this.val = val;
                for (int i = 0; i < this.successes.size(); ++i) {
                    this.successes.remove(i).onSuccess(val);
                    --i;
                }
            }
        });
        result.onError((Throwable err) -> {
            Object object = lockObject;
            synchronized (object) {
                err.printStackTrace();
                if (this.count <= 0) {
                    this.onError(err);
                } else {
                    --this.count;
                    try {
                        this.setResult(this.doResult.doResult(this.count, err));
                    }
                    catch (Exception e) {
                        this.onError(e);
                    }
                }
            }
        });
    }

    private void onError(Throwable e) {
        for (int i = 0; i < this.errors.size(); ++i) {
            this.errors.remove(i).onError(e);
            --i;
        }
    }

    @Override
    public synchronized Result onSuccess(ResultSuccess success) {
        if (this.val != null) {
            success.onSuccess(this.val);
            return this;
        }
        this.successes.add(success);
        return this;
    }

    @Override
    public synchronized Result onError(ResultError error) {
        this.errors.add(error);
        return this;
    }

    @Override
    public Object getValue() {
        throw new JobException("no getValue");
    }
}

