/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.job;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.risesoft.api.exceptions.JobException;
import net.risesoft.api.job.TaskManager;
import net.risesoft.api.persistence.model.job.Job;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.CronTrigger;

public class JobTask
implements Runnable,
Trigger {
    private Job job;
    private TaskManager taskManager;
    private Map<String, Object> metaInfo;

    public JobTask() {
    }

    public JobTask(Job job, TaskManager taskManager) {
        this.job = job;
        this.taskManager = taskManager;
    }

    public synchronized void putInfo(String key, Object value) {
        if (this.metaInfo == null) {
            this.metaInfo = new HashMap<String, Object>();
        }
        this.metaInfo.put(key, value);
    }

    @Override
    public void run() {
        if (this.taskManager.hasTask(this.job.getId())) {
            this.taskManager.getTaskExecutor().startJob(this.job);
        } else {
            this.taskManager.removeJob(this.job.getId(), this);
        }
    }

    public synchronized Date nextExecutionTime(TriggerContext triggerContext) {
        switch (this.job.getDispatchType()) {
            case "cron": {
                CronTrigger cronTrigger = new CronTrigger(this.job.getSpeed());
                Date nextExecTime = cronTrigger.nextExecutionTime(triggerContext);
                return nextExecTime;
            }
            case "\u56fa\u5b9a\u901f\u5ea6": {
                return new Date(System.currentTimeMillis() + (long)(Integer.parseInt(this.job.getSpeed()) * 1000));
            }
        }
        throw new JobException("\u672a\u77e5\u7684\u8c03\u5ea6\u901f\u5ea6\u7c7b\u578b" + this.job.getDispatchType());
    }

    public synchronized void onChange(Job job) {
        if (this.job.getSpeed().equals(job.getSpeed())) {
            this.job = job;
        } else {
            this.job = job;
            this.taskManager.refreshJob(this);
        }
    }

    public Object getInfo(String key) {
        if (this.metaInfo == null) {
            return null;
        }
        return this.metaInfo.get(key);
    }
}

