/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.api;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.risedata.register.service.IServiceInstance;
import net.risedata.rpc.consumer.annotation.Listeners;
import net.risedata.rpc.provide.annotation.API;
import net.risedata.rpc.provide.annotation.Param;
import net.risedata.rpc.provide.annotation.RPCServer;
import net.risedata.rpc.provide.context.RPCRequestContext;
import net.risesoft.api.exceptions.RegisterException;
import net.risesoft.api.persistence.iservice.IServiceService;
import net.risesoft.api.persistence.model.IServiceInstanceModel;
import net.risesoft.api.watch.WatchManager;
import net.risesoft.security.SecurityManager;
import net.risesoft.security.model.NetworkWhiteList;
import net.risesoft.security.service.EnvironmentService;
import net.risesoft.security.service.NetworkWhiteListService;
import net.risesoft.util.PattenUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Listeners
@RestController(value="register")
@RPCServer(name="register", enableRequest=true)
public class RegisterApi {
    public static final String CONNECTION_INSTANCE_ID = "CONNECTION_INSTANCE_ID";
    public static final String CONNECTION_INSTANCE_NAME = "CONNECTION_INSTANCE_NAME";
    public static final String INSTANCE_ENVIRONMENT_NAME = "INSTANCE_ENVIRONMENT_NAME";
    public static final String REMOVED_ALL_REGISTER = "REGISTER_REMOVED_ALL_REGISTER";
    @Autowired
    WatchManager watchManager;
    public static final List<IServiceInstance> EMPTY = new ArrayList<IServiceInstance>();
    @Value(value="${beta.discovery.service:${spring.application.name:}}")
    String MYSERVICENAME;
    @Autowired
    SecurityManager securityManager;
    @Autowired
    NetworkWhiteListService networkWhiteListService;
    @Autowired(required=false)
    IServiceService iServiceService;
    @Autowired
    EnvironmentService environmentService;

    @API
    public Map<String, List<IServiceInstanceModel>> getServices(@RequestParam(required=false, defaultValue="Public") @Param(required=false, defaultValue="Public") String environment) {
        return this.iServiceService.getUseAll(environment);
    }

    private boolean check(String environment, IServiceInstanceModel iServiceInstance, String ip) {
        return this.checkeOfIp(environment, ip, iServiceInstance);
    }

    private boolean checkeOfIp(String environment, String ip, IServiceInstanceModel iServiceInstance) {
        List networkWhiteList = this.networkWhiteListService.getNetworkWhiteList(environment);
        if (networkWhiteList == null || networkWhiteList.size() == 0) {
            return true;
        }
        for (NetworkWhiteList whiteList : networkWhiteList) {
            if (!PattenUtil.hasMatch((String[])this.networkWhiteListService.getStrs(whiteList.getIpMatch()), (String)ip) || !PattenUtil.hasMatch((String[])this.networkWhiteListService.getStrs(whiteList.getService()), (String)iServiceInstance.getServiceId())) continue;
            return true;
        }
        return false;
    }

    public boolean register(IServiceInstanceModel serviceInstance) {
        if (StringUtils.isEmpty((CharSequence)serviceInstance.getEnvironment())) {
            serviceInstance.setEnvironment("Public");
        }
        serviceInstance.setUpdateTime(System.currentTimeMillis());
        if (serviceInstance.getRegisterTime() == null || serviceInstance.getRegisterTime() == 0L) {
            serviceInstance.setRegisterTime(System.currentTimeMillis());
        }
        this.environmentService.getEnvironmentByName(serviceInstance.getEnvironment());
        return this.iServiceService.saveModel(serviceInstance);
    }

    @API(name="register")
    public boolean registerToServer(IServiceInstanceModel serviceInstance, RPCRequestContext rpcRequestContext) {
        if (StringUtils.isEmpty((CharSequence)serviceInstance.getHost())) {
            serviceInstance.setHost(((InetSocketAddress)rpcRequestContext.getConcurrentConnection().getRemoteAddress()).getHostString());
        }
        String ip = this.securityManager.getConcurrentIp();
        if (StringUtils.isBlank((CharSequence)serviceInstance.getEnvironment())) {
            serviceInstance.setEnvironment("Public");
        }
        if (!this.check(serviceInstance.getEnvironment(), serviceInstance, ip)) {
            throw new RegisterException("no security");
        }
        serviceInstance.setCustom(false);
        rpcRequestContext.getConcurrentConnection().setAttribute(INSTANCE_ENVIRONMENT_NAME, (Object)serviceInstance.getEnvironment());
        rpcRequestContext.getConcurrentConnection().setAttribute(CONNECTION_INSTANCE_NAME, (Object)serviceInstance.getServiceId());
        rpcRequestContext.getConcurrentConnection().setAttribute(CONNECTION_INSTANCE_ID, (Object)serviceInstance.getInstanceId());
        return this.register(serviceInstance);
    }

    @API
    public boolean remove(String name, String instanceId) {
        return this.iServiceService.delById(instanceId);
    }

    @API
    public boolean reNew(RPCRequestContext rpcRequestContext) {
        Object instanceId = rpcRequestContext.getConcurrentConnection().getAttribute(CONNECTION_INSTANCE_ID);
        if (instanceId != null) {
            return this.iServiceService.updateNowTime((String)instanceId) > 0;
        }
        throw new RegisterException("no instance id");
    }

    @RequestMapping(value={"/getServices"})
    public Map<String, List<IServiceInstanceModel>> getServicesAll(@RequestParam(required=false, defaultValue="Public") String environment) {
        return this.iServiceService.getUseAll(environment);
    }
}

