/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.watch;

import io.netty.util.HashedWheelTimer;
import io.netty.util.TimerTask;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.risedata.register.service.IServiceInstanceFactory;
import net.risesoft.api.persistence.iservice.IServiceService;
import net.risesoft.api.persistence.model.IServiceInstanceModel;
import net.risesoft.api.watch.CheckStatusTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.annotation.Scheduled;

public class WatchManager
implements ApplicationContextAware {
    private static final Map<String, CheckStatusTask> WATCH_TASK = new ConcurrentHashMap<String, CheckStatusTask>();
    private static HashedWheelTimer hashedWheelTimer = new HashedWheelTimer();
    public static final Logger LOGGER = LoggerFactory.getLogger(WatchManager.class);
    @Value(value="${beta.service.watch.startTime:100}")
    private Integer startTime;
    @Autowired
    private IServiceService iServiceService;
    @Autowired
    IServiceInstanceFactory iServiceInstanceFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTask(String instanceId, CheckStatusTask checkStatusTask) {
        Map<String, CheckStatusTask> map = WATCH_TASK;
        synchronized (map) {
            CheckStatusTask statusTask = WATCH_TASK.get(instanceId);
            if (statusTask == checkStatusTask) {
                WATCH_TASK.remove(instanceId);
            }
        }
    }

    @Scheduled(fixedDelayString="${beta.service.watch.refreshTime:60000}", initialDelayString="${beta.service.watch.refreshTime:60000}")
    public void onRefresh() {
        List<IServiceInstanceModel> instanceModels = this.iServiceService.findWatch(this.iServiceInstanceFactory.getIsntance().getInstanceId(), this.iServiceInstanceFactory.getIsntance().getEnvironment(), this.iServiceInstanceFactory.getIsntance().getServiceId());
        for (IServiceInstanceModel instanceModel : instanceModels) {
            this.iServiceService.updateWatch(this.iServiceInstanceFactory.getIsntance().getInstanceId(), instanceModel.getWatchServer(), instanceModel.getInstanceId());
        }
        this.checkTask();
    }

    private void checkTask() {
        Set<String> keySet = WATCH_TASK.keySet();
        String[] ids = keySet.toArray(new String[keySet.size()]);
        this.iServiceService.updateNoWatch(ids);
        List<String> misss = this.iServiceService.findMiss(this.iServiceInstanceFactory.getIsntance().getInstanceId(), ids);
        for (String key : misss) {
            this.addTask(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTask(CheckStatusTask task, String instanceId) {
        Map<String, CheckStatusTask> map = WATCH_TASK;
        synchronized (map) {
            return WATCH_TASK.get(instanceId) == task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(String instanceId) {
        CheckStatusTask checkStatusTask = new CheckStatusTask(instanceId, this.iServiceInstanceFactory.getIsntance().getInstanceId(), this.iServiceService);
        Map<String, CheckStatusTask> map = WATCH_TASK;
        synchronized (map) {
            WATCH_TASK.put(instanceId, checkStatusTask);
        }
        hashedWheelTimer.newTimeout((TimerTask)checkStatusTask, (long)this.startTime.intValue(), TimeUnit.MILLISECONDS);
    }

    public static boolean get(String id) {
        return WATCH_TASK.containsKey(id);
    }

    public static Map<String, CheckStatusTask> getWatchTask() {
        return WATCH_TASK;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        hashedWheelTimer = new HashedWheelTimer();
        hashedWheelTimer.start();
    }

    public static void closeApplication() {
        WATCH_TASK.clear();
        hashedWheelTimer.stop();
        LOGGER.info("close watch");
    }
}

