/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.utils.jdbc.filedTypeMapping;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.risesoft.api.utils.jdbc.filedTypeMapping.TypeDefinition;

public class JdbcTypeMappingCache {
    private static Map<String, Map<String, Integer>> databaseTypeMappingCache = new HashMap<String, Map<String, Integer>>();
    private static Map<String, List<String>> databaseTypeListCache = new HashMap<String, List<String>>();
    private static Map<String, List<TypeDefinition>> databaseTypeCache = new HashMap<String, List<TypeDefinition>>();

    public static Map<String, Integer> getFieldTypeMapping(String driver, String url, String username, String password, String baseType) {
        if (databaseTypeMappingCache.containsKey(baseType)) {
            return databaseTypeMappingCache.get(baseType);
        }
        ArrayList<String> typeNameList = new ArrayList<String>();
        HashMap<String, Integer> typeMappingCache = new HashMap<String, Integer>();
        try (Connection connection = JdbcTypeMappingCache.getConnection(driver, url, username, password);){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet typeInfo = metaData.getTypeInfo();
            while (typeInfo.next()) {
                String typeName = typeInfo.getString("TYPE_NAME");
                if (typeName.startsWith("_")) continue;
                int dataType = typeInfo.getInt("DATA_TYPE");
                typeMappingCache.put(typeName, dataType);
                typeNameList.add(typeName);
            }
            databaseTypeMappingCache.put(baseType, typeMappingCache);
            databaseTypeListCache.put(baseType, typeNameList);
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
        return typeMappingCache;
    }

    public static List<String> getFieldTypeList(String driver, String url, String username, String password, String baseType) {
        if (databaseTypeListCache.containsKey(baseType)) {
            return databaseTypeListCache.get(baseType);
        }
        ArrayList<String> typeNameList = new ArrayList<String>();
        HashMap<String, Integer> typeMappingCache = new HashMap<String, Integer>();
        try (Connection connection = JdbcTypeMappingCache.getConnection(driver, url, username, password);){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet typeInfo = metaData.getTypeInfo();
            while (typeInfo.next()) {
                String typeName = typeInfo.getString("TYPE_NAME");
                if (typeName.startsWith("_")) continue;
                int dataType = typeInfo.getInt("DATA_TYPE");
                int precision = typeInfo.getInt("PRECISION");
                System.out.println(precision);
                typeNameList.add(typeName + "--" + precision);
                typeMappingCache.put(typeName, dataType);
            }
            databaseTypeListCache.put(baseType, typeNameList);
            databaseTypeMappingCache.put(baseType, typeMappingCache);
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
        return typeNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TypeDefinition> getFieldType(String driver, String url, String username, String password, String baseType) {
        if (databaseTypeCache.containsKey(baseType)) {
            return databaseTypeCache.get(baseType);
        }
        Connection connection = null;
        ResultSet typeInfo = null;
        ArrayList<TypeDefinition> typeDefinitionList = new ArrayList<TypeDefinition>();
        try {
            connection = JdbcTypeMappingCache.getConnection(driver, url, username, password);
            DatabaseMetaData metaData = connection.getMetaData();
            typeInfo = metaData.getTypeInfo();
            while (typeInfo.next()) {
                boolean istrue;
                String typeName = typeInfo.getString("TYPE_NAME");
                if (typeName.startsWith("_") || (istrue = typeDefinitionList.stream().anyMatch(e -> e.getTypeName() != null && e.getTypeName().equals(typeName)))) continue;
                int typeNum = typeInfo.getInt("DATA_TYPE");
                int precision = typeInfo.getInt("PRECISION");
                typeDefinitionList.add(new TypeDefinition(typeName, typeNum, precision));
            }
            databaseTypeCache.put(baseType, typeDefinitionList);
        }
        catch (ClassNotFoundException | SQLException e2) {
            try {
                e2.printStackTrace();
            }
            catch (Throwable throwable) {
                JdbcTypeMappingCache.ReleaseResource(connection, typeInfo);
                throw throwable;
            }
            JdbcTypeMappingCache.ReleaseResource(connection, typeInfo);
        }
        JdbcTypeMappingCache.ReleaseResource(connection, typeInfo);
        return typeDefinitionList;
    }

    private static Connection getConnection(String driver, String url, String username, String password) throws SQLException, ClassNotFoundException {
        Class.forName(driver);
        Properties props = new Properties();
        props.setProperty("user", username);
        props.setProperty("password", password);
        props.setProperty("remarks", "true");
        props.setProperty("useInformationSchema", "true");
        return DriverManager.getConnection(url, props);
    }

    public static void ReleaseResource(Connection connection, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

