/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.factory.OperationBuilderFactory;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.operation.Where;
import net.risedata.jdbc.operation.impl.CustomOperation;

public class SqlUtils {
    private static int maxSize = 999;

    public static Operation toInLike(String field, List<String> ins) {
        return new CustomOperation(where -> {
            if (ins.isEmpty() || ins.size() == 1 && "%%".equals(ins.get(0))) {
                return false;
            }
            String fieldC = where.getCloum(field);
            where.append((CharSequence)"(");
            for (int i = 0; i < ins.size(); ++i) {
                if (i != 0) {
                    where.append((CharSequence)" or ");
                }
                where.append((CharSequence)(fieldC + " like ? "));
                where.add(ins.get(i));
            }
            where.append((CharSequence)")");
            return true;
        });
    }

    public static void appendIn(List<String> ins, Where where) {
        where.append((CharSequence)"(");
        for (int i = 0; i < ins.size(); ++i) {
            if (i != 0) {
                where.append((CharSequence)",?");
            } else {
                where.append((CharSequence)"?");
            }
            where.add((Object)ins.get(i));
        }
        where.append((CharSequence)")");
    }

    public static <T> void toInsSql(T[] ids, String sqlPre, StringBuilder sql) {
        sql.append("(");
        int split = ids.length % maxSize == 0 ? ids.length / maxSize : ids.length / maxSize + 1;
        for (int i = 0; i < split; ++i) {
            if (i != 0) {
                sql.append(" or ");
            }
            sql.append(sqlPre).append("(");
            T[] oids = Arrays.copyOfRange(ids, i * 999, i == split - 1 ? ids.length : (i + 1) * 999);
            for (int j = 0; j < oids.length; ++j) {
                if (j != 0) {
                    sql.append(",?");
                    continue;
                }
                sql.append("?");
            }
            sql.append(")");
        }
        sql.append(")");
    }

    public static Operation toInLike(String field, String[] ins, boolean isPre) {
        return new CustomOperation(where -> {
            if (ins == null || ins.length == 0 || ins.length == 1 && "**".equals(ins[0])) {
                return false;
            }
            String pre = isPre ? "%" : "";
            String fieldC = where.getCloum(field);
            where.append((CharSequence)"(");
            for (int i = 0; i < ins.length; ++i) {
                if (i != 0) {
                    where.append((CharSequence)" or ");
                }
                where.append((CharSequence)(fieldC + " like ? "));
                where.add((Object)(pre + ins[i].replace("**", "%").replace("*", "%")));
            }
            where.append((CharSequence)")");
            return true;
        });
    }

    public static Map<String, Operation> createInlikeOperaion(String field, String cluom, String[] ins, boolean isPre) {
        return OperationBuilderFactory.builder((String)field, (Operation)SqlUtils.toInLike(cluom, ins, isPre));
    }
}

