/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.security;

import net.risedata.rpc.model.Response;
import net.risedata.rpc.provide.annotation.RPCFilter;
import net.risedata.rpc.provide.context.RPCRequestContext;
import net.risedata.rpc.provide.context.Send;
import net.risedata.rpc.provide.filter.Filter;
import net.risedata.rpc.provide.filter.FilterContext;
import org.springframework.stereotype.Component;

@RPCFilter
@Component
public class RPCRequestFilter
implements Filter {
    private static ThreadLocal<RPCRequestContext> THREAD_LOCAL = new ThreadLocal();

    public void doBefore(RPCRequestContext context, FilterContext filterContext) throws Exception {
        THREAD_LOCAL.set(context);
        filterContext.doBefore(context);
    }

    public void doAfter(Response response, RPCRequestContext context, FilterContext filterContext, Send send) throws Exception {
        THREAD_LOCAL.remove();
        filterContext.doAfter(response, context, send);
    }

    public static RPCRequestContext getCurrent() {
        return THREAD_LOCAL.get();
    }

    public int getOrder() {
        return 0;
    }
}

