/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.message.impl;

import java.util.ArrayList;
import net.risesoft.api.message.MessageServiceExecutor;
import net.risesoft.api.utils.RegexUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;

public class EmailServiceExecutor
implements MessageServiceExecutor {
    @Value(value="${spring.mail.username:}")
    private String from;
    @Autowired
    private JavaMailSender mailSender;

    public void sendSimpleMail(String[] tos, String subject, String content) {
        SimpleMailMessage message = new SimpleMailMessage();
        message.setTo(tos);
        message.setFrom(this.from);
        message.setSubject(subject);
        message.setText(content);
        this.mailSender.send(message);
    }

    @Override
    public void sendMessage(String[] recipients, String title, String message, Object source) {
        ArrayList<String> emails = new ArrayList<String>();
        for (String recipient : recipients) {
            if (!RegexUtil.isEmail(recipient)) continue;
            emails.add(recipient);
        }
        if (emails.size() > 0) {
            this.sendSimpleMail(emails.toArray(new String[emails.size()]), title, message);
        }
    }
}

