/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.message.impl;

import java.util.List;
import net.risesoft.api.listener.JobListener;
import net.risesoft.api.message.InstanceMessage;
import net.risesoft.api.message.JobMessage;
import net.risesoft.api.message.MessageService;
import net.risesoft.api.message.MessageServiceExecutor;
import net.risesoft.api.persistence.model.IServiceInstanceModel;
import net.risesoft.api.persistence.model.job.Job;
import net.risesoft.api.persistence.model.job.JobLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DefaultMessageService
implements MessageService {
    @Autowired(required=false)
    List<MessageServiceExecutor> serviceExecutors;
    @Autowired(required=false)
    List<JobListener> jobListeners;
    @Value(value="${beta.job.contacts:}")
    String contacts;
    @Autowired
    InstanceMessage instanceMessage;
    @Autowired
    JobMessage jobMessage;

    @Override
    public void sendMessage(String[] recipients, String title, String message, Object source) {
        if (this.serviceExecutors == null) {
            return;
        }
        for (MessageServiceExecutor serviceExecutor : this.serviceExecutors) {
            serviceExecutor.sendMessage(recipients, title, message, source);
        }
    }

    @Override
    public void onServiceDown(IServiceInstanceModel serviceInstanceModel) {
        String message = this.instanceMessage.createContent(serviceInstanceModel);
        String title = this.instanceMessage.createTitle(serviceInstanceModel);
        this.sendMessage(serviceInstanceModel.getManagerInfo() != null ? serviceInstanceModel.getManagerInfo().split(",") : new String[]{}, title, message, serviceInstanceModel);
    }

    @Override
    public void onJobError(Job job) {
        String message = this.jobMessage.createContent(job);
        String title = this.jobMessage.createTitle(job);
        this.sendMessage(!StringUtils.isEmpty((Object)job.getEmail()) ? job.getEmail().split(",") : (!StringUtils.isEmpty((Object)this.contacts) ? this.contacts.split(",") : new String[]{}), title, message, job);
    }

    @Override
    public void onJobEnd(Job job, JobLog jobLog) {
        if (this.jobListeners != null) {
            for (JobListener jobListener : this.jobListeners) {
                jobListener.endJob(job, jobLog);
            }
        }
    }
}

