/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.job.actions.dispatch.executor.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.risesoft.api.exceptions.JobException;
import net.risesoft.api.job.actions.dispatch.executor.Result;
import net.risesoft.api.job.actions.dispatch.executor.ResultError;
import net.risesoft.api.job.actions.dispatch.executor.ResultSuccess;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.util.EntityUtils;

class HttpRequest
implements FutureCallback<HttpResponse>,
Result {
    private String url;
    private List<ResultSuccess> successes = new ArrayList<ResultSuccess>();
    private List<ResultError> errors = new ArrayList<ResultError>();

    public HttpRequest() {
    }

    public HttpRequest(String url) {
        this.url = url;
    }

    public void completed(HttpResponse result) {
        String content = null;
        try {
            content = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
        }
        catch (IOException e) {
            this.failed(e);
        }
        if (result.getStatusLine().getStatusCode() == 200) {
            for (int i = 0; i < this.successes.size(); ++i) {
                this.successes.remove(i).onSuccess(content);
                --i;
            }
        } else {
            this.failed(new JobException(this.url + " error_status: " + result.getStatusLine() + " error" + content));
        }
    }

    public void failed(Exception ex) {
        for (int i = 0; i < this.errors.size(); ++i) {
            this.errors.remove(i).onError(ex);
            --i;
        }
    }

    public void cancelled() {
        this.failed(new JobException("\u4efb\u52a1\u88ab\u53d6\u6d88"));
    }

    @Override
    public Result onSuccess(ResultSuccess success) {
        this.successes.add(success);
        return this;
    }

    @Override
    public Result onError(ResultError error) {
        this.errors.add(error);
        return this;
    }

    @Override
    public Object getValue() {
        throw new JobException("no getValue");
    }
}

