/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.job;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.risedata.register.service.IServiceInstanceFactory;
import net.risedata.rpc.consumer.annotation.Listener;
import net.risedata.rpc.consumer.annotation.Listeners;
import net.risedata.rpc.provide.config.Application;
import net.risesoft.api.job.JobTask;
import net.risesoft.api.job.ScheduledRegister;
import net.risesoft.api.job.TaskExecutorService;
import net.risesoft.api.listener.ClientListener;
import net.risesoft.api.persistence.job.JobChangeService;
import net.risesoft.api.persistence.job.JobLogService;
import net.risesoft.api.persistence.job.JobService;
import net.risesoft.api.persistence.model.job.Job;
import net.risesoft.api.persistence.model.job.JobLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Listeners
public class TaskManager {
    @Autowired
    private JobService jobService;
    @Autowired
    private IServiceInstanceFactory iServiceInstanceFactory;
    @Autowired
    private TaskExecutorService taskExecutor;
    private static final Map<Integer, JobTask> JOB_TASK = new ConcurrentHashMap<Integer, JobTask>();
    @Autowired
    JobLogService jobLogService;
    @Autowired
    private JobChangeService jobChangeService;
    @Autowired
    private ScheduledRegister scheduledRegister;
    public static final String ON_JOB_CHANGE = "ON_JOB_CHANGE";

    public TaskExecutorService getTaskExecutor() {
        return this.taskExecutor;
    }

    public boolean isBlock(Job job, String logId) {
        return this.jobLogService.isBlock(job.getId(), job.getTimeOut(), logId);
    }

    public synchronized void pushTask(Job job, JobLog jobLog) {
        this.jobLogService.updateStatus(jobLog.getId(), -1, jobLog.getStatus());
        if (!this.isBlock(job, jobLog.getId())) {
            this.pollJob(job, job.getId());
        }
    }

    @Scheduled(fixedDelayString="${beta.job.refreshTime:30000}", initialDelayString="${beta.job.refreshTime:30000}")
    public void onRefresh() {
        List<Job> jobs = this.jobService.findWatch(this.iServiceInstanceFactory.getIsntance().getInstanceId(), this.iServiceInstanceFactory.getIsntance().getEnvironment(), this.iServiceInstanceFactory.getIsntance().getServiceId());
        for (Job job : jobs) {
            if (!this.jobService.updateWatch(job.getId(), this.iServiceInstanceFactory.getIsntance().getInstanceId(), job.getDispatchServer())) continue;
            this.addTask(job);
        }
        this.checkJob();
    }

    @Scheduled(cron="0 0 0 * * ?")
    public void clearLog() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        this.jobLogService.clearLog(calendar.getTime());
    }

    private void refreshChangeJob() {
        List<Integer> changeJobs = this.jobChangeService.searchChangeJobs();
        if (changeJobs.size() != 0) {
            JobTask jobTask = null;
            for (Integer jobId : changeJobs) {
                jobTask = JOB_TASK.get(jobId);
                if (jobTask == null) continue;
                jobTask.onChange(this.jobService.findByJobId(jobId));
                this.jobChangeService.delete(jobId);
            }
        }
    }

    @Scheduled(fixedDelayString="${beta.job.clearTime:60000}", initialDelayString="${beta.job.clearTime:60000}")
    public void clearTimeAndDelete() {
        Set<Integer> ids = JOB_TASK.keySet();
        if (ids.size() > 0) {
            this.jobLogService.clearTimeOutJob();
        }
    }

    private void checkJob() {
        Set<Integer> keySet = JOB_TASK.keySet();
        Integer[] ids = keySet.toArray(new Integer[keySet.size()]);
        if (keySet.size() != 0) {
            this.refreshChangeJob();
            this.jobService.updateNoWatch(ids);
        }
        List<Job> misss = this.jobService.findMiss(this.iServiceInstanceFactory.getIsntance().getInstanceId(), ids, JOB_TASK);
        for (Job job : misss) {
            this.addTask(job);
        }
    }

    public void putInfo(Integer jobId, String key, Object value) {
        JobTask jobTask = JOB_TASK.get(jobId);
        if (jobTask != null) {
            jobTask.putInfo(key, value);
        }
    }

    public <T> T getInfo(Integer jobId, String key, Class<T> cla) {
        JobTask jobTask = JOB_TASK.get(jobId);
        if (jobTask != null) {
            Object info = jobTask.getInfo(key);
            return info != null ? (T)cla.cast(jobTask.getInfo(key)) : null;
        }
        return null;
    }

    public void removeJob(Integer jobId, JobTask jobTask) {
        JOB_TASK.remove(jobId);
        this.scheduledRegister.removeTask(jobTask);
    }

    public void refreshJob(JobTask jobTask) {
        this.scheduledRegister.removeTask(jobTask);
        this.scheduledRegister.addTriggerTask(jobTask, jobTask);
    }

    public void addTask(Job job) {
        JobTask task = JOB_TASK.get(job.getId());
        if (task != null) {
            task.onChange(job);
            return;
        }
        JobTask jobTask = new JobTask(job, this);
        JOB_TASK.put(job.getId(), jobTask);
        try {
            this.scheduledRegister.addTriggerTask(jobTask, jobTask);
        }
        catch (Exception e) {
            e.printStackTrace();
            Application.logger.error("\u4efb\u52a1\u6dfb\u52a0\u5931\u8d25\u5df2\u505c\u6b62\u4efb\u52a1\u4efb\u52a1\u4fe1\u606f: " + job);
            this.jobService.setStatus(job.getId(), 0);
            JOB_TASK.remove(job.getId());
            return;
        }
        List<String> logs = this.taskExecutor.getLogs(job.getId());
        String blockingStrategy = job.getBlockingStrategy();
        if (blockingStrategy.equals("\u4e32\u884c")) {
            List<JobLog> jobLogs = this.jobLogService.findDownJobs(job.getId(), logs);
            if (jobLogs.size() > 0) {
                for (JobLog jobLog : jobLogs) {
                    this.taskExecutor.appendLog(jobLog.getId(), "\u672a\u77e5\u539f\u56e0\u4efb\u52a1\u6389\u7ebf\u91cd\u65b0\u8c03\u5ea6:");
                    this.taskExecutor.startJob(job, jobLog, null);
                }
            }
        } else {
            JobLog jobLog1 = this.jobLogService.findDownJob(job.getId(), logs);
            if (jobLog1 != null) {
                this.taskExecutor.appendLog(jobLog1.getId(), "\u672a\u77e5\u539f\u56e0\u4efb\u52a1\u6389\u7ebf\u91cd\u65b0\u8c03\u5ea6:");
                this.taskExecutor.startJob(job, jobLog1, null);
            }
        }
    }

    public void pushJobChange(Integer id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", id);
        this.onChangeJob(id);
        ClientListener.pushListener(ON_JOB_CHANGE, map, this.iServiceInstanceFactory.getIsntance().getServiceId(), null, null);
    }

    @Listener(value="ON_JOB_CHANGE")
    public void onChangeJob(Integer id) {
        Job job = this.jobService.findByJobIdAndUse(id);
        if (job != null) {
            this.addTask(job);
        }
    }

    public boolean hasTask(Integer id) {
        return this.jobService.hasTask(id);
    }

    public void endJob(Job job, Integer jobId) {
        this.pollJob(job, jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollJob(Job job, Integer jobId) {
        String string = jobId.toString().intern();
        synchronized (string) {
            JobLog jobLog = this.jobLogService.pollJob(jobId, job.getTimeOut());
            if (jobLog != null) {
                this.taskExecutor.appendLog(jobLog.getId(), "\u91cd\u65b0\u6267\u884c\u6b64\u4efb\u52a1-----" + job);
                this.taskExecutor.startJob(job, jobLog, null);
            }
        }
    }
}

