/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.utils.jdbc;

import com.alibaba.druid.util.HexBin;
import java.io.Closeable;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public final class JdbcUtils {
    public static final String JTDS = "jtds";
    public static final String MOCK = "mock";
    public static final String HSQL = "hsql";
    public static final String DB2 = "db2";
    public static final String DB2_DRIVER = "COM.ibm.db2.jdbc.app.DB2Driver";
    public static final String POSTGRESQL = "postgresql";
    public static final String POSTGRESQL_DRIVER = "org.postgresql.Driver";
    public static final String SYBASE = "sybase";
    public static final String SQL_SERVER = "sqlserver";
    public static final String SQL_SERVER_DRIVER = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    public static final String ORACLE = "oracle";
    public static final String ORACLE_DRIVER = "oracle.jdbc.OracleDriver";
    public static final String ALI_ORACLE = "AliOracle";
    public static final String ALI_ORACLE_DRIVER = "com.alibaba.jdbc.AlibabaDriver";
    public static final String MYSQL = "mysql";
    public static final String MYSQL_DRIVER = "com.mysql.jdbc.Driver";
    public static final String MARIADB = "mariadb";
    public static final String MARIADB_DRIVER = "org.mariadb.jdbc.Driver";
    public static final String DERBY = "derby";
    public static final String HBASE = "hbase";
    public static final String HIVE = "hive";
    public static final String H2 = "h2";
    public static final String H2_DRIVER = "org.h2.Driver";
    public static final String DM = "dm";
    public static final String DM_DRIVER = "dm.jdbc.driver.DmDriver";
    public static final String KINGBASE = "kingbase";
    public static final String KINGBASE_DRIVER = "com.kingbase.Driver";
    public static final String ODPS = "odps";
    public static final String LOG4JDBC = "log4jdbc";
    public static final String LOG4JDBC_DRIVER = "net.sf.log4jdbc.DriverSpy";
    private static final Properties DRIVER_URL_MAPPING = new Properties();

    public static void close(Connection x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void close(Statement x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void close(ResultSet x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void close(Closeable x) {
        if (x == null) {
            return;
        }
        try {
            x.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void printResultSet(ResultSet rs) throws SQLException {
        JdbcUtils.printResultSet(rs, System.out);
    }

    public static void printResultSet(ResultSet rs, PrintStream out) throws SQLException {
        JdbcUtils.printResultSet(rs, out, true, "\t");
    }

    public static void printResultSet(ResultSet rs, PrintStream out, boolean printHeader, String seperator) throws SQLException {
        int columnIndex;
        ResultSetMetaData metadata = rs.getMetaData();
        int columnCount = metadata.getColumnCount();
        if (printHeader) {
            for (columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                if (columnIndex != 1) {
                    out.print(seperator);
                }
                out.print(metadata.getColumnName(columnIndex));
            }
        }
        out.println();
        while (rs.next()) {
            for (columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                Object object;
                int type;
                if (columnIndex != 1) {
                    out.print(seperator);
                }
                if ((type = metadata.getColumnType(columnIndex)) == 12 || type == 1 || type == -9 || type == -15) {
                    out.print(rs.getString(columnIndex));
                    continue;
                }
                if (type == 91) {
                    Date date = rs.getDate(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(date.toString());
                    continue;
                }
                if (type == -7) {
                    boolean value = rs.getBoolean(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Boolean.toString(value));
                    continue;
                }
                if (type == 16) {
                    boolean value = rs.getBoolean(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Boolean.toString(value));
                    continue;
                }
                if (type == -6) {
                    byte value = rs.getByte(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Byte.toString(value));
                    continue;
                }
                if (type == 5) {
                    short value = rs.getShort(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Short.toString(value));
                    continue;
                }
                if (type == 4) {
                    int value = rs.getInt(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Integer.toString(value));
                    continue;
                }
                if (type == -5) {
                    long value = rs.getLong(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(Long.toString(value));
                    continue;
                }
                if (type == 93) {
                    out.print(String.valueOf(rs.getTimestamp(columnIndex)));
                    continue;
                }
                if (type == 3) {
                    out.print(String.valueOf(rs.getBigDecimal(columnIndex)));
                    continue;
                }
                if (type == 2005) {
                    out.print(String.valueOf(rs.getString(columnIndex)));
                    continue;
                }
                if (type == 2000) {
                    object = rs.getObject(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(String.valueOf(object));
                    continue;
                }
                if (type == -1) {
                    object = rs.getString(columnIndex);
                    if (rs.wasNull()) {
                        out.print("null");
                        continue;
                    }
                    out.print(String.valueOf(object));
                    continue;
                }
                if (type == 0) {
                    out.print("null");
                    continue;
                }
                object = rs.getObject(columnIndex);
                if (rs.wasNull()) {
                    out.print("null");
                    continue;
                }
                if (object instanceof byte[]) {
                    byte[] bytes = (byte[])object;
                    String text = HexBin.encode((byte[])bytes);
                    out.print(text);
                    continue;
                }
                out.print(String.valueOf(object));
            }
            out.println();
        }
    }

    public static String getTypeName(int sqlType) {
        switch (sqlType) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -15: {
                return "NCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case -9: {
                return "NVARCHAR";
            }
            case 7: {
                return "REAL";
            }
            case 2006: {
                return "REF";
            }
            case -8: {
                return "ROWID";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2009: {
                return "SQLXML";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "OTHER";
    }

    public static String getDriverClassName(String rawUrl) throws SQLException {
        if (rawUrl.startsWith("jdbc:derby:")) {
            return "org.apache.derby.jdbc.EmbeddedDriver";
        }
        if (rawUrl.startsWith("jdbc:mysql:")) {
            return MYSQL_DRIVER;
        }
        if (rawUrl.startsWith("jdbc:log4jdbc:")) {
            return LOG4JDBC_DRIVER;
        }
        if (rawUrl.startsWith("jdbc:mariadb:")) {
            return MARIADB_DRIVER;
        }
        if (rawUrl.startsWith("jdbc:oracle:") || rawUrl.startsWith("JDBC:oracle:")) {
            return ORACLE_DRIVER;
        }
        if (rawUrl.startsWith("jdbc:alibaba:oracle:")) {
            return ALI_ORACLE_DRIVER;
        }
        if (rawUrl.startsWith("jdbc:microsoft:")) {
            return SQL_SERVER_DRIVER;
        }
        if (rawUrl.startsWith("jdbc:sqlserver:")) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (rawUrl.startsWith("jdbc:sybase:Tds:")) {
            return "com.sybase.jdbc2.jdbc.SybDriver";
        }
        if (rawUrl.startsWith("jdbc:jtds:")) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:fake:") || rawUrl.startsWith("jdbc:mock:")) {
            return "com.alibaba.druid.mock.MockDriver";
        }
        if (rawUrl.startsWith("jdbc:postgresql:")) {
            return POSTGRESQL_DRIVER;
        }
        if (rawUrl.startsWith("jdbc:hsqldb:")) {
            return "org.hsqldb.jdbcDriver";
        }
        if (rawUrl.startsWith("jdbc:db2:")) {
            return DB2_DRIVER;
        }
        if (rawUrl.startsWith("jdbc:sqlite:")) {
            return "org.sqlite.JDBC";
        }
        if (rawUrl.startsWith("jdbc:ingres:")) {
            return "com.ingres.jdbc.IngresDriver";
        }
        if (rawUrl.startsWith("jdbc:h2:")) {
            return H2_DRIVER;
        }
        if (rawUrl.startsWith("jdbc:mckoi:")) {
            return "com.mckoi.JDBCDriver";
        }
        if (rawUrl.startsWith("jdbc:cloudscape:")) {
            return "COM.cloudscape.core.JDBCDriver";
        }
        if (rawUrl.startsWith("jdbc:informix-sqli:")) {
            return "com.informix.jdbc.IfxDriver";
        }
        if (rawUrl.startsWith("jdbc:timesten:")) {
            return "com.timesten.jdbc.TimesTenDriver";
        }
        if (rawUrl.startsWith("jdbc:as400:")) {
            return "com.ibm.as400.access.AS400JDBCDriver";
        }
        if (rawUrl.startsWith("jdbc:sapdb:")) {
            return "com.sap.dbtech.jdbc.DriverSapDB";
        }
        if (rawUrl.startsWith("jdbc:JSQLConnect:")) {
            return "com.jnetdirect.jsql.JSQLDriver";
        }
        if (rawUrl.startsWith("jdbc:JTurbo:")) {
            return "com.newatlanta.jturbo.driver.Driver";
        }
        if (rawUrl.startsWith("jdbc:firebirdsql:")) {
            return "org.firebirdsql.jdbc.FBDriver";
        }
        if (rawUrl.startsWith("jdbc:interbase:")) {
            return "interbase.interclient.Driver";
        }
        if (rawUrl.startsWith("jdbc:pointbase:")) {
            return "com.pointbase.jdbc.jdbcUniversalDriver";
        }
        if (rawUrl.startsWith("jdbc:edbc:")) {
            return "ca.edbc.jdbc.EdbcDriver";
        }
        if (rawUrl.startsWith("jdbc:mimer:multi1:")) {
            return "com.mimer.jdbc.Driver";
        }
        if (rawUrl.startsWith("jdbc:dm:")) {
            return DM_DRIVER;
        }
        if (rawUrl.startsWith("jdbc:kingbase:")) {
            return KINGBASE_DRIVER;
        }
        throw new SQLException("unkow jdbc driver : " + rawUrl);
    }

    public static String getDbType(String rawUrl, String driverClassName) {
        if (rawUrl == null) {
            return null;
        }
        if (rawUrl.startsWith("jdbc:derby:") || rawUrl.startsWith("jdbc:log4jdbc:derby:")) {
            return DERBY;
        }
        if (rawUrl.startsWith("jdbc:mysql:") || rawUrl.startsWith("jdbc:cobar:") || rawUrl.startsWith("jdbc:log4jdbc:mysql:")) {
            return MYSQL;
        }
        if (rawUrl.startsWith("jdbc:mariadb:")) {
            return MARIADB;
        }
        if (rawUrl.startsWith("jdbc:oracle:") || rawUrl.startsWith("jdbc:log4jdbc:oracle:")) {
            return ORACLE;
        }
        if (rawUrl.startsWith("jdbc:alibaba:oracle:")) {
            return ALI_ORACLE;
        }
        if (rawUrl.startsWith("jdbc:microsoft:") || rawUrl.startsWith("jdbc:log4jdbc:microsoft:")) {
            return SQL_SERVER;
        }
        if (rawUrl.startsWith("jdbc:sqlserver:") || rawUrl.startsWith("jdbc:log4jdbc:sqlserver:")) {
            return SQL_SERVER;
        }
        if (rawUrl.startsWith("jdbc:sybase:Tds:") || rawUrl.startsWith("jdbc:log4jdbc:sybase:")) {
            return SYBASE;
        }
        if (rawUrl.startsWith("jdbc:jtds:") || rawUrl.startsWith("jdbc:log4jdbc:jtds:")) {
            return JTDS;
        }
        if (rawUrl.startsWith("jdbc:fake:") || rawUrl.startsWith("jdbc:mock:")) {
            return MOCK;
        }
        if (rawUrl.startsWith("jdbc:postgresql:") || rawUrl.startsWith("jdbc:log4jdbc:postgresql:")) {
            return POSTGRESQL;
        }
        if (rawUrl.startsWith("jdbc:hsqldb:") || rawUrl.startsWith("jdbc:log4jdbc:hsqldb:")) {
            return HSQL;
        }
        if (rawUrl.startsWith("jdbc:db2:")) {
            return DB2;
        }
        if (rawUrl.startsWith("jdbc:sqlite:")) {
            return "sqlite";
        }
        if (rawUrl.startsWith("jdbc:ingres:")) {
            return "ingres";
        }
        if (rawUrl.startsWith("jdbc:h2:") || rawUrl.startsWith("jdbc:log4jdbc:h2:")) {
            return H2;
        }
        if (rawUrl.startsWith("jdbc:mckoi:")) {
            return "mckoi";
        }
        if (rawUrl.startsWith("jdbc:cloudscape:")) {
            return "cloudscape";
        }
        if (rawUrl.startsWith("jdbc:informix-sqli:") || rawUrl.startsWith("jdbc:log4jdbc:informix-sqli:")) {
            return "informix";
        }
        if (rawUrl.startsWith("jdbc:timesten:")) {
            return "timesten";
        }
        if (rawUrl.startsWith("jdbc:as400:")) {
            return "as400";
        }
        if (rawUrl.startsWith("jdbc:sapdb:")) {
            return "sapdb";
        }
        if (rawUrl.startsWith("jdbc:JSQLConnect:")) {
            return "JSQLConnect";
        }
        if (rawUrl.startsWith("jdbc:JTurbo:")) {
            return "JTurbo";
        }
        if (rawUrl.startsWith("jdbc:firebirdsql:")) {
            return "firebirdsql";
        }
        if (rawUrl.startsWith("jdbc:interbase:")) {
            return "interbase";
        }
        if (rawUrl.startsWith("jdbc:pointbase:")) {
            return "pointbase";
        }
        if (rawUrl.startsWith("jdbc:edbc:")) {
            return "edbc";
        }
        if (rawUrl.startsWith("jdbc:mimer:multi1:")) {
            return "mimer";
        }
        if (rawUrl.startsWith("jdbc:dm:")) {
            return DM;
        }
        if (rawUrl.startsWith("jdbc:kingbase:")) {
            return KINGBASE;
        }
        if (rawUrl.startsWith("jdbc:log4jdbc:")) {
            return LOG4JDBC;
        }
        return null;
    }

    public static Driver createDriver(String driverClassName) throws SQLException {
        return JdbcUtils.createDriver(null, driverClassName);
    }

    public static Driver createDriver(ClassLoader classLoader, String driverClassName) throws SQLException {
        Class<?> clazz = null;
        if (classLoader != null) {
            try {
                clazz = classLoader.loadClass(driverClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
                if (contextLoader != null) {
                    clazz = contextLoader.loadClass(driverClassName);
                }
            }
            catch (ClassNotFoundException contextLoader) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException(e.getMessage(), e);
            }
        }
        try {
            return (Driver)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    public static int executeUpdate(DataSource dataSource, String sql, Object ... parameters) throws SQLException {
        return JdbcUtils.executeUpdate(dataSource, sql, Arrays.asList(parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(DataSource dataSource, String sql, List<Object> parameters) throws SQLException {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            int n = JdbcUtils.executeUpdate(conn, sql, parameters);
            return n;
        }
        finally {
            JdbcUtils.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeUpdate(Connection conn, String sql, List<Object> parameters) throws SQLException {
        int updateCount;
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            JdbcUtils.setParameters(stmt, parameters);
            updateCount = stmt.executeUpdate();
        }
        finally {
            JdbcUtils.close(stmt);
        }
        return updateCount;
    }

    public static void execute(DataSource dataSource, String sql, Object ... parameters) throws SQLException {
        JdbcUtils.execute(dataSource, sql, Arrays.asList(parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(DataSource dataSource, String sql, List<Object> parameters) throws SQLException {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            JdbcUtils.execute(conn, sql, parameters);
        }
        finally {
            JdbcUtils.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Connection conn, String sql, List<Object> parameters) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(sql);
            JdbcUtils.setParameters(stmt, parameters);
            stmt.executeUpdate();
        }
        finally {
            JdbcUtils.close(stmt);
        }
    }

    public static List<Map<String, Object>> executeQuery(DataSource dataSource, String sql, Object ... parameters) throws SQLException {
        return JdbcUtils.executeQuery(dataSource, sql, Arrays.asList(parameters));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> executeQuery(DataSource dataSource, String sql, List<Object> parameters) throws SQLException {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            List<Map<String, Object>> list = JdbcUtils.executeQuery(conn, sql, parameters);
            return list;
        }
        finally {
            JdbcUtils.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> executeQuery(Connection conn, String sql, List<Object> parameters) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            JdbcUtils.setParameters(stmt, parameters);
            rs = stmt.executeQuery();
            ResultSetMetaData rsMeta = rs.getMetaData();
            while (rs.next()) {
                LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
                int size = rsMeta.getColumnCount();
                for (int i = 0; i < size; ++i) {
                    String columName = rsMeta.getColumnLabel(i + 1);
                    Object value = rs.getObject(i + 1);
                    row.put(columName, value);
                }
                rows.add(row);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.close(rs);
            JdbcUtils.close(stmt);
            throw throwable;
        }
        JdbcUtils.close(rs);
        JdbcUtils.close(stmt);
        return rows;
    }

    private static void setParameters(PreparedStatement stmt, List<Object> parameters) throws SQLException {
        int size = parameters.size();
        for (int i = 0; i < size; ++i) {
            Object param = parameters.get(i);
            stmt.setObject(i + 1, param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertToTable(DataSource dataSource, String tableName, Map<String, Object> data) throws SQLException {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            JdbcUtils.insertToTable(conn, tableName, data);
        }
        finally {
            JdbcUtils.close(conn);
        }
    }

    public static void insertToTable(Connection conn, String tableName, Map<String, Object> data) throws SQLException {
        String sql = JdbcUtils.makeInsertToTableSql(tableName, data.keySet());
        ArrayList<Object> parameters = new ArrayList<Object>(data.values());
        JdbcUtils.execute(conn, sql, parameters);
    }

    public static String makeInsertToTableSql(String tableName, Collection<String> names) {
        StringBuilder sql = new StringBuilder().append("insert into ").append(tableName).append("(");
        int nameCount = 0;
        for (String name : names) {
            if (nameCount > 0) {
                sql.append(",");
            }
            sql.append(name);
            ++nameCount;
        }
        sql.append(") values (");
        for (int i = 0; i < nameCount; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.append(")");
        return sql.toString();
    }
}

