/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.utils.jdbc;

import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.risesoft.api.utils.jdbc.DataBaseType;
import net.risesoft.api.utils.jdbc.RetryUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public final class DBUtil {
    private static final ThreadLocal<ExecutorService> rsExecutors = new ThreadLocal<ExecutorService>(){

        @Override
        protected ExecutorService initialValue() {
            return Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("rsExecutors-%d").setDaemon(true).build());
        }
    };

    private DBUtil() {
    }

    public static String chooseJdbcUrl(final DataBaseType dataBaseType, final List<String> jdbcUrls, final String username, final String password, final List<String> preSql, final boolean checkSlave) {
        if (null == jdbcUrls || jdbcUrls.isEmpty()) {
            throw new RuntimeException(String.format("\u60a8\u7684jdbcUrl\u7684\u914d\u7f6e\u4fe1\u606f\u6709\u9519, \u56e0\u4e3ajdbcUrl[%s]\u4e0d\u80fd\u4e3a\u7a7a. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", StringUtils.join(jdbcUrls, (String)",")));
        }
        try {
            return RetryUtil.executeWithRetry(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    boolean connOK = false;
                    for (String url : jdbcUrls) {
                        if (!StringUtils.isNotBlank((CharSequence)url)) continue;
                        url = url.trim();
                        connOK = null != preSql && !preSql.isEmpty() ? DBUtil.testConnWithoutRetry(dataBaseType, url, username, password, preSql) : DBUtil.testConnWithoutRetry(dataBaseType, url, username, password, checkSlave);
                        if (!connOK) continue;
                        return url;
                    }
                    throw new RuntimeException("\u65e0\u6cd5\u8fde\u63a5\u5bf9\u5e94\u7684\u6570\u636e\u5e93\uff0c\u53ef\u80fd\u539f\u56e0\u662f\uff1a1) \u914d\u7f6e\u7684ip/port/database/jdbc\u9519\u8bef\uff0c\u65e0\u6cd5\u8fde\u63a5\u30022) \u914d\u7f6e\u7684username/password\u9519\u8bef\uff0c\u9274\u6743\u5931\u8d25\u3002\u8bf7\u548cDBA\u786e\u8ba4\u8be5\u6570\u636e\u5e93\u7684\u8fde\u63a5\u4fe1\u606f\u662f\u5426\u6b63\u786e\u3002");
                }
            }, 7, 1000L, true);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25. \u56e0\u4e3a\u6839\u636e\u60a8\u914d\u7f6e\u7684\u8fde\u63a5\u4fe1\u606f,\u65e0\u6cd5\u4ece:%s \u4e2d\u627e\u5230\u53ef\u8fde\u63a5\u7684jdbcUrl. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", StringUtils.join(jdbcUrls, (String)",")), e);
        }
    }

    public static String chooseJdbcUrlWithoutRetry(DataBaseType dataBaseType, List<String> jdbcUrls, String username, String password, List<String> preSql, boolean checkSlave) throws Exception {
        if (null == jdbcUrls || jdbcUrls.isEmpty()) {
            throw new RuntimeException(String.format("\u60a8\u7684jdbcUrl\u7684\u914d\u7f6e\u4fe1\u606f\u6709\u9519, \u56e0\u4e3ajdbcUrl[%s]\u4e0d\u80fd\u4e3a\u7a7a. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", StringUtils.join(jdbcUrls, (String)",")));
        }
        boolean connOK = false;
        for (String url : jdbcUrls) {
            if (!StringUtils.isNotBlank((CharSequence)url)) continue;
            url = url.trim();
            if (null != preSql && !preSql.isEmpty()) {
                connOK = DBUtil.testConnWithoutRetry(dataBaseType, url, username, password, preSql);
            } else {
                try {
                    connOK = DBUtil.testConnWithoutRetry(dataBaseType, url, username, password, checkSlave);
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25. \u56e0\u4e3a\u6839\u636e\u60a8\u914d\u7f6e\u7684\u8fde\u63a5\u4fe1\u606f,\u65e0\u6cd5\u4ece:%s \u4e2d\u627e\u5230\u53ef\u8fde\u63a5\u7684jdbcUrl. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", StringUtils.join(jdbcUrls, (String)",")), e);
                }
            }
            if (!connOK) continue;
            return url;
        }
        throw new RuntimeException(String.format("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25. \u56e0\u4e3a\u6839\u636e\u60a8\u914d\u7f6e\u7684\u8fde\u63a5\u4fe1\u606f,\u65e0\u6cd5\u4ece:%s \u4e2d\u627e\u5230\u53ef\u8fde\u63a5\u7684jdbcUrl. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", StringUtils.join(jdbcUrls, (String)",")));
    }

    private static boolean isSlaveBehind(Connection conn) {
        try {
            ResultSet rs1;
            String readOnly;
            ResultSet rs = DBUtil.query(conn, "SHOW VARIABLES LIKE 'read_only'");
            if (DBUtil.asyncResultSetNext(rs) && "ON".equalsIgnoreCase(readOnly = rs.getString("Value")) && DBUtil.asyncResultSetNext(rs1 = DBUtil.query(conn, "SHOW SLAVE STATUS"))) {
                String ioRunning = rs1.getString("Slave_IO_Running");
                String sqlRunning = rs1.getString("Slave_SQL_Running");
                long secondsBehindMaster = rs1.getLong("Seconds_Behind_Master");
                if ("Yes".equalsIgnoreCase(ioRunning) && "Yes".equalsIgnoreCase(sqlRunning)) {
                    ResultSet rs2 = DBUtil.query(conn, "SELECT TIMESTAMPDIFF(SECOND, CURDATE(), NOW())");
                    DBUtil.asyncResultSetNext(rs2);
                    long secondsOfDay = rs2.getLong(1);
                    return secondsBehindMaster > secondsOfDay;
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean hasInsertPrivilege(DataBaseType dataBaseType, String jdbcURL, String userName, String password, List<String> tableList) {
        String[] urls = jdbcURL.split("/");
        if (urls == null || urls.length == 0) {
            return false;
        }
        String dbName = urls[3];
        String dbPattern = "`" + dbName + "`.*";
        HashSet<String> tableNames = new HashSet<String>(tableList.size());
        tableNames.addAll(tableList);
        Connection connection = DBUtil.connect(dataBaseType, jdbcURL, userName, password);
        try {
            ResultSet rs = DBUtil.query(connection, "SHOW GRANTS FOR " + userName);
            while (DBUtil.asyncResultSetNext(rs)) {
                String grantRecord = rs.getString("Grants for " + userName + "@%");
                String[] params = grantRecord.split("\\`");
                if (params != null && params.length >= 3) {
                    String tableName = params[3];
                    if (!params[0].contains("INSERT") || tableName.equals("*") || !tableNames.contains(tableName)) continue;
                    tableNames.remove(tableName);
                    continue;
                }
                if (!grantRecord.contains("INSERT") && !grantRecord.contains("ALL PRIVILEGES")) continue;
                if (grantRecord.contains("*.*")) {
                    return true;
                }
                if (!grantRecord.contains(dbPattern)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tableNames.isEmpty();
    }

    public static boolean checkInsertPrivilege(DataBaseType dataBaseType, String jdbcURL, String userName, String password, List<String> tableList) {
        Connection connection = DBUtil.connect(dataBaseType, jdbcURL, userName, password);
        String insertTemplate = "insert into %s(select * from %s where 1 = 2)";
        boolean hasInsertPrivilege = true;
        Statement insertStmt = null;
        for (String tableName : tableList) {
            String checkInsertPrivilegeSql = String.format(insertTemplate, tableName, tableName);
            try {
                insertStmt = connection.createStatement();
                DBUtil.executeSqlWithoutResultSet(insertStmt, checkInsertPrivilegeSql);
            }
            catch (Exception e) {
                if (DataBaseType.Oracle.equals((Object)dataBaseType)) {
                    if (e.getMessage() == null || !e.getMessage().contains("insufficient privileges")) continue;
                    hasInsertPrivilege = false;
                    continue;
                }
                hasInsertPrivilege = false;
            }
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return hasInsertPrivilege;
    }

    public static boolean checkDeletePrivilege(DataBaseType dataBaseType, String jdbcURL, String userName, String password, List<String> tableList) {
        Connection connection = DBUtil.connect(dataBaseType, jdbcURL, userName, password);
        String deleteTemplate = "delete from %s WHERE 1 = 2";
        boolean hasInsertPrivilege = true;
        Statement deleteStmt = null;
        for (String tableName : tableList) {
            String checkDeletePrivilegeSQL = String.format(deleteTemplate, tableName);
            try {
                deleteStmt = connection.createStatement();
                DBUtil.executeSqlWithoutResultSet(deleteStmt, checkDeletePrivilegeSQL);
            }
            catch (Exception e) {
                hasInsertPrivilege = false;
            }
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return hasInsertPrivilege;
    }

    public static Connection getConnection(DataBaseType dataBaseType, String jdbcUrl, String username, String password) {
        return DBUtil.getConnection(dataBaseType, jdbcUrl, username, password, String.valueOf(172800000));
    }

    public static Connection getConnection(final DataBaseType dataBaseType, final String jdbcUrl, final String username, final String password, final String socketTimeout) {
        try {
            return RetryUtil.executeWithRetry(new Callable<Connection>(){

                @Override
                public Connection call() throws Exception {
                    return DBUtil.connect(dataBaseType, jdbcUrl, username, password, socketTimeout);
                }
            }, 5, 1000L, true);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25. \u56e0\u4e3a\u6839\u636e\u60a8\u914d\u7f6e\u7684\u8fde\u63a5\u4fe1\u606f:%s\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", jdbcUrl), e);
        }
    }

    public static Connection getConnectionWithoutRetry(DataBaseType dataBaseType, String jdbcUrl, String username, String password) {
        return DBUtil.getConnectionWithoutRetry(dataBaseType, jdbcUrl, username, password, String.valueOf(172800000));
    }

    public static Connection getConnectionWithoutRetry(DataBaseType dataBaseType, String jdbcUrl, String username, String password, String socketTimeout) {
        return DBUtil.connect(dataBaseType, jdbcUrl, username, password, socketTimeout);
    }

    private static synchronized Connection connect(DataBaseType dataBaseType, String url, String user, String pass) {
        return DBUtil.connect(dataBaseType, url, user, pass, String.valueOf(172800000));
    }

    private static synchronized Connection connect(DataBaseType dataBaseType, String url, String user, String pass, String socketTimeout) {
        Properties prop;
        block6: {
            block5: {
                if (url.startsWith("||_dsc_ob10_dsc_||") && dataBaseType == DataBaseType.MySql) {
                    String[] ss = url.split("\\|\\|_dsc_ob10_dsc_\\|\\|");
                    if (ss.length != 3) {
                        throw new RuntimeException("JDBC OB10\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfbaskdatax");
                    }
                    user = ss[1].trim() + ":" + (String)user;
                    url = ss[2];
                }
                prop = new Properties();
                prop.put("user", user);
                prop.put("password", pass);
                if (dataBaseType == DataBaseType.Oracle) break block5;
                if (dataBaseType != DataBaseType.RDBMS) break block6;
            }
            prop.put("oracle.jdbc.ReadTimeout", socketTimeout);
            prop.put("initialSize", (Object)10);
            prop.put("maxActive", (Object)50);
            prop.put("maxWait", (Object)60000);
            prop.put("minIdle", (Object)5);
        }
        return DBUtil.connect(dataBaseType, url, prop);
    }

    private static synchronized Connection connect(DataBaseType dataBaseType, String url, Properties prop) {
        try {
            Class.forName(dataBaseType.getDriverClassName());
            DriverManager.setLoginTimeout(15);
            return DriverManager.getConnection(url, prop);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage() + "user:" + prop.getProperty("user"), null);
        }
    }

    public static ResultSet query(Connection conn, String sql, int fetchSize) throws SQLException {
        return DBUtil.query(conn, sql, fetchSize, 172800);
    }

    public static ResultSet query(Connection conn, String sql, int fetchSize, int queryTimeout) throws SQLException {
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement(1003, 1007);
        stmt.setFetchSize(fetchSize);
        stmt.setQueryTimeout(queryTimeout);
        return DBUtil.query(stmt, sql);
    }

    public static ResultSet query(Statement stmt, String sql) throws SQLException {
        return stmt.executeQuery(sql);
    }

    public static void executeSqlWithoutResultSet(Statement stmt, String sql) throws SQLException {
        stmt.execute(sql);
    }

    public static void closeResultSet(ResultSet rs) {
        try {
            if (null != rs) {
                Statement stmt = rs.getStatement();
                if (null != stmt) {
                    stmt.close();
                    stmt = null;
                }
                rs.close();
            }
            rs = null;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void closeDBResources(ResultSet rs, Statement stmt, Connection conn) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (null != stmt) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (null != conn) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeDBResources(Statement stmt, Connection conn) {
        DBUtil.closeDBResources(null, stmt, conn);
    }

    public static List<String> getTableColumns(DataBaseType dataBaseType, String jdbcUrl, String user, String pass, String tableName) {
        Connection conn = DBUtil.getConnection(dataBaseType, jdbcUrl, user, pass);
        return DBUtil.getTableColumnsByConn(dataBaseType, conn, tableName, "jdbcUrl:" + jdbcUrl);
    }

    public static List<String> getTableColumnsByConn(DataBaseType dataBaseType, Connection conn, String tableName, String basicMsg) {
        ArrayList<String> columns = new ArrayList<String>();
        Statement statement = null;
        ResultSet rs = null;
        String queryColumnSql = null;
        try {
            statement = conn.createStatement();
            queryColumnSql = String.format("select * from %s where 1=2", tableName);
            rs = statement.executeQuery(queryColumnSql);
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int len = rsMetaData.getColumnCount();
            for (int i = 0; i < len; ++i) {
                columns.add(rsMetaData.getColumnLabel(i + 1));
            }
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e.getMessage() + "sql:" + queryColumnSql + "tableName" + tableName);
            }
            catch (Throwable throwable) {
                DBUtil.closeDBResources(rs, statement, conn);
                throw throwable;
            }
        }
        DBUtil.closeDBResources(rs, statement, conn);
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Triple<List<String>, List<Integer>, List<String>> getColumnMetaData(DataBaseType dataBaseType, String jdbcUrl, String user, String pass, String tableName, String column) {
        Connection conn = null;
        try {
            conn = DBUtil.getConnection(dataBaseType, jdbcUrl, user, pass);
            Triple<List<String>, List<Integer>, List<String>> triple = DBUtil.getColumnMetaData(conn, tableName, column);
            return triple;
        }
        finally {
            DBUtil.closeDBResources(null, null, conn);
        }
    }

    public static Triple<List<String>, List<Integer>, List<String>> getColumnMetaData(Connection conn, String tableName, String column) {
        ImmutableTriple immutableTriple;
        Statement statement = null;
        ResultSet rs = null;
        ImmutableTriple columnMetaData = new ImmutableTriple(new ArrayList(), new ArrayList(), new ArrayList());
        try {
            statement = conn.createStatement();
            String queryColumnSql = "select " + column + " from " + tableName + " where 1=2";
            rs = statement.executeQuery(queryColumnSql);
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int len = rsMetaData.getColumnCount();
            for (int i = 0; i < len; ++i) {
                ((List)columnMetaData.getLeft()).add(rsMetaData.getColumnLabel(i + 1));
                ((List)columnMetaData.getMiddle()).add(rsMetaData.getColumnType(i + 1));
                ((List)columnMetaData.getRight()).add(rsMetaData.getColumnTypeName(i + 1));
            }
            immutableTriple = columnMetaData;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(String.format("\u83b7\u53d6\u8868:%s \u7684\u5b57\u6bb5\u7684\u5143\u4fe1\u606f\u65f6\u5931\u8d25. \u8bf7\u8054\u7cfb DBA \u6838\u67e5\u8be5\u5e93\u3001\u8868\u4fe1\u606f.", tableName), e);
            }
            catch (Throwable throwable) {
                DBUtil.closeDBResources(rs, statement, null);
                throw throwable;
            }
        }
        DBUtil.closeDBResources(rs, statement, null);
        return immutableTriple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean testConnWithoutRetry(DataBaseType dataBaseType, String url, String user, String pass, boolean checkSlave) {
        block7: {
            Connection connection;
            block5: {
                boolean bl;
                block6: {
                    boolean connOk;
                    connection = null;
                    connection = DBUtil.connect(dataBaseType, url, user, pass);
                    if (connection == null) break block5;
                    if (!dataBaseType.equals((Object)DataBaseType.MySql) || !checkSlave) break block6;
                    boolean bl2 = connOk = !DBUtil.isSlaveBehind(connection);
                    DBUtil.closeDBResources(null, connection);
                    return bl2;
                }
                try {
                    bl = true;
                }
                catch (Exception exception) {
                    DBUtil.closeDBResources(null, connection);
                    break block7;
                    catch (Throwable throwable) {
                        DBUtil.closeDBResources(null, connection);
                        throw throwable;
                    }
                }
                DBUtil.closeDBResources(null, connection);
                return bl;
            }
            DBUtil.closeDBResources(null, connection);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean testConnWithoutRetry(DataBaseType dataBaseType, String url, String user, String pass, List<String> preSql) {
        boolean bl;
        Connection connection;
        block8: {
            boolean bl2;
            connection = null;
            try {
                Iterator<String> iterator;
                connection = DBUtil.connect(dataBaseType, url, user, pass);
                if (null != connection) {
                    iterator = preSql.iterator();
                } else {
                    DBUtil.closeDBResources(null, connection);
                    return false;
                }
                while (iterator.hasNext()) {
                    String pre = iterator.next();
                    if (DBUtil.doPreCheck(connection, pre)) continue;
                    bl = false;
                    break block8;
                }
                bl2 = true;
            }
            catch (Exception exception) {
                DBUtil.closeDBResources(null, connection);
                return false;
                catch (Throwable throwable) {
                    DBUtil.closeDBResources(null, connection);
                    throw throwable;
                }
            }
            DBUtil.closeDBResources(null, connection);
            return bl2;
        }
        DBUtil.closeDBResources(null, connection);
        return bl;
    }

    public static boolean isOracleMaster(final String url, final String user, final String pass) {
        try {
            return RetryUtil.executeWithRetry(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    block3: {
                        Boolean bl;
                        Connection conn = null;
                        try {
                            conn = DBUtil.connect(DataBaseType.Oracle, url, user, pass);
                            ResultSet rs = DBUtil.query(conn, "select DATABASE_ROLE from V$DATABASE");
                            if (!DBUtil.asyncResultSetNext(rs, 5)) break block3;
                            String role = rs.getString("DATABASE_ROLE");
                            bl = "PRIMARY".equalsIgnoreCase(role);
                        }
                        catch (Throwable throwable) {
                            DBUtil.closeDBResources(null, conn);
                            throw throwable;
                        }
                        DBUtil.closeDBResources(null, conn);
                        return bl;
                    }
                    throw new RuntimeException(String.format("select DATABASE_ROLE from V$DATABASE failed,\u8bf7\u68c0\u67e5\u60a8\u7684jdbcUrl:%s.", url));
                }
            }, 3, 1000L, true);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("select DATABASE_ROLE from V$DATABASE failed, url: %s", url), e);
        }
    }

    public static ResultSet query(Connection conn, String sql) throws SQLException {
        Statement stmt = conn.createStatement(1003, 1007);
        stmt.setQueryTimeout(172800);
        return DBUtil.query(stmt, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doPreCheck(Connection conn, String pre) {
        ResultSet rs = null;
        try {
            rs = DBUtil.query(conn, pre);
            int checkResult = -1;
            if (DBUtil.asyncResultSetNext(rs)) {
                checkResult = rs.getInt(1);
                if (DBUtil.asyncResultSetNext(rs)) {
                    boolean bl = false;
                    return bl;
                }
            }
            if (0 == checkResult) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception exception) {
        }
        finally {
            DBUtil.closeResultSet(rs);
        }
        return false;
    }

    public static void sqlValid(String sql, DataBaseType dataBaseType) {
        SQLStatementParser statementParser = SQLParserUtils.createSQLStatementParser((String)sql, (String)dataBaseType.getTypeName(), (SQLParserFeature[])new SQLParserFeature[0]);
        statementParser.parseStatementList();
    }

    public static boolean asyncResultSetNext(ResultSet resultSet) {
        return DBUtil.asyncResultSetNext(resultSet, 3600);
    }

    public static boolean asyncResultSetNext(final ResultSet resultSet, int timeout) {
        Future<Boolean> future = rsExecutors.get().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return resultSet.next();
            }
        });
        try {
            return future.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException("\u5f02\u6b65\u83b7\u53d6ResultSet\u5931\u8d25", e);
        }
    }
}

