/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.utils;

import java.util.concurrent.atomic.AtomicInteger;
import net.risesoft.api.job.actions.dispatch.executor.Result;
import net.risesoft.api.utils.LResult;

public class ResultUtils {
    public static LResult batchResult(LResult ... results) {
        LResult lResult = new LResult();
        AtomicInteger size = new AtomicInteger(results.length);
        Object[] res = new Object[results.length];
        for (int i = 0; i < results.length; ++i) {
            int index = i;
            results[i].onEnd(success -> {
                res[index] = success;
                if (size.decrementAndGet() == 0) {
                    lResult.end(res);
                }
            });
        }
        return lResult;
    }

    public static LResult batchResult(Result ... results) {
        LResult lResult = new LResult();
        AtomicInteger size = new AtomicInteger(results.length);
        Object[] res = new Object[results.length];
        for (int i = 0; i < results.length; ++i) {
            int index = i;
            results[i].onSuccess(success -> {
                res[index] = success;
                if (size.decrementAndGet() == 0) {
                    lResult.end(res);
                }
            }).onError(err -> {
                res[index] = err;
                if (size.decrementAndGet() == 0) {
                    lResult.end(res);
                }
            });
        }
        return lResult;
    }
}

