/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.risesoft.api.persistence.model.config.Config;
import net.risesoft.api.utils.JsonUtils;
import org.yaml.snakeyaml.Yaml;

public class PropertiesUtil {
    private static final String PATH = System.getProperty("user.dir");

    public static Map<String, String> stringToMap(String content) throws Exception {
        Properties properties = new Properties();
        properties.load(new ByteArrayInputStream("ss:':'".getBytes()));
        HashMap<Object, Object> map = new HashMap<Object, Object>(properties);
        return map;
    }

    public static Map<String, Object> getMap(Config config) throws Exception {
        String content = config.getContent();
        switch (config.getType()) {
            case "yaml": {
                Yaml yaml = new Yaml();
                Map testMap = (Map)yaml.load(content);
                return JsonUtils.json2propMap(JSONObject.parseObject((String)JSONObject.toJSONString((Object)testMap)));
            }
            case "json": {
                return JSONObject.parseObject((String)content);
            }
            case "properties": {
                PropertiesUtil.stringToMap(content);
                break;
            }
        }
        return null;
    }

    public static Map<String, String> getMap(String path) {
        Properties properties = new Properties();
        properties = PropertiesUtil.readFile(PATH + path);
        HashMap<Object, Object> map = new HashMap<Object, Object>(properties);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readFile(String path) {
        File file = new File(path);
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            properties.load(in);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return properties;
    }
}

