/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.persistence.security.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.commons.LPage;
import net.risedata.jdbc.factory.OperationBuilderFactory;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.operation.impl.CustomOperation;
import net.risedata.jdbc.search.LPageable;
import net.risedata.jdbc.service.impl.AutomaticCrudService;
import net.risesoft.api.exceptions.ServiceOperationException;
import net.risesoft.api.persistence.dao.UserDao;
import net.risesoft.api.persistence.model.security.DataUser;
import net.risesoft.api.persistence.security.UserService;
import net.risesoft.api.utils.AutoIdUtil;
import net.risesoft.api.utils.MD5Util;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
extends AutomaticCrudService<DataUser, String>
implements UserService {
    @Autowired
    UserDao userDao;

    @Override
    public LPage<DataUser> searchForPage(DataUser entiry, LPageable page) {
        return super.getSearchExecutor().searchForPage((Object)entiry, "ID,USER_NAME,ACCOUNT,CREATE_DATE", page, null, null, null, DataUser.class);
    }

    @Override
    public DataUser checkLogin(String account, String password) {
        DataUser user = this.userDao.getUser(account, MD5Util.md5(password));
        if (user == null) {
            throw new ServiceOperationException("\u7528\u6237\u8d26\u53f7\u6216\u8005\u5bc6\u7801\u9519\u8bef");
        }
        return user;
    }

    @Override
    public String createUser(DataUser dataUser) {
        DataUser user = new DataUser();
        user.setAccount(dataUser.getAccount());
        if (this.search(user).size() > 0) {
            throw new RuntimeException("\u8d26\u53f7\u5b58\u5728!");
        }
        user.setId(AutoIdUtil.getRandomId26());
        user.setUserName(dataUser.getUserName());
        user.setPassword(MD5Util.md5(dataUser.getPassword()));
        user.setCreateDate(new Date());
        this.insert(user);
        return user.getId();
    }

    @Override
    public void updatePassword(String userId, String password) {
        this.userDao.updatePassword(MD5Util.md5(password), userId);
    }

    @Override
    public Integer deleteUser(String userId) {
        DataUser dataUser = this.findOne(userId);
        if (dataUser != null && dataUser.getUserName().equals("admin")) {
            throw new ServiceOperationException("\u7cfb\u7edf\u7ba1\u7406\u5458\u65e0\u6cd5\u5220\u9664");
        }
        return this.userDao.deleteUser(userId);
    }

    @Override
    public List<String> findAll() {
        return this.userDao.findAll();
    }

    @Override
    public DataUser findOne(String id) {
        return (DataUser)this.getOne(id);
    }

    @Override
    public Integer updateInfoById(DataUser user) {
        user.setPassword(null);
        DataUser betaUser = (DataUser)this.getOne(user.getId());
        if (betaUser == null) {
            throw new ServiceOperationException("\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        return this.updateById(user);
    }

    @Override
    public LPage<DataUser> searchForPageRole(DataUser betaUser, LPageable page, String roleId, boolean isNot) {
        return this.searchForPage(betaUser, page, null, (Map)OperationBuilderFactory.builder((String)"id", (Operation)new CustomOperation(where -> {
            where.append((CharSequence)("id " + (isNot ? "not" : "") + " in(select user_id from Y9_DATASERVICE_ROLE_USER_LINK where role_id =?)"));
            where.add((Object)roleId);
            return true;
        })));
    }

    @Override
    public Integer hasName(String name) {
        return this.userDao.hasName(name);
    }
}

