/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.persistence.security.impl;

import java.util.List;
import java.util.Map;
import net.risedata.jdbc.factory.OperationBuilderFactory;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.operation.impl.InOperation;
import net.risedata.jdbc.service.impl.AutomaticCrudService;
import net.risesoft.api.exceptions.ServiceOperationException;
import net.risesoft.api.persistence.dao.CommonDao;
import net.risesoft.api.persistence.dao.EnvironmentDao;
import net.risesoft.api.persistence.model.security.Environment;
import net.risesoft.api.persistence.security.EnvironmentService;
import net.risesoft.api.utils.AutoIdUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EnvironmentServiceImpl
extends AutomaticCrudService<Environment, String>
implements EnvironmentService {
    public static final String PUBLIC = "Public";
    @Autowired
    EnvironmentDao environmentDao;
    @Autowired
    CommonDao commonDao;

    @Override
    public List<Environment> findAll() {
        return this.searchAll();
    }

    @Override
    public void insertEnvironment(Environment role) {
        if (this.environmentDao.hasByName(role.getName(), "null") > 0) {
            throw new ServiceOperationException("\u5df2\u5b58\u5728: " + role.getName());
        }
        role.setId(AutoIdUtil.getRandomId26());
        this.save(role);
    }

    @Override
    public void delById(String id) {
        if (PUBLIC.equals(id)) {
            throw new ServiceOperationException("\u9ed8\u8ba4\u73af\u5883\u4e0d\u80fd\u5220\u9664");
        }
        this.deleteById(id);
    }

    @Override
    public String getEnvironmentById(String environment) {
        String name = this.environmentDao.findById(environment);
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new ServiceOperationException("\u6ca1\u6709\u627e\u5230\u8be5\u73af\u5883" + environment);
        }
        return name;
    }

    @Override
    public String getEnvironmentByName(String environment) {
        String id = this.environmentDao.findByName(environment);
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new ServiceOperationException("\u6ca1\u6709\u627e\u5230\u8be5\u73af\u5883" + environment);
        }
        return id;
    }

    @Override
    public List<String> findNameByIds(List<String> environments) {
        return this.commonDao.findNameByIds(Environment.class, environments);
    }

    @Override
    public List<Environment> findForEnvironment(List<String> environments) {
        if (environments.size() == 0) {
            return null;
        }
        return this.search("*", null, (Map)OperationBuilderFactory.builder((String)"id", (Operation)new InOperation(true, environments)));
    }

    @Override
    public synchronized void updateEnvironment(Environment environment) {
        if (this.environmentDao.hasByName(environment.getName(), environment.getId()) > 0) {
            throw new ServiceOperationException("\u5df2\u5b58\u5728: " + environment.getName());
        }
        this.environmentDao.updateEnvironment(environment.getName(), environment.getDescription(), environment.getId());
    }
}

