/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.persistence.job.impl;

import cn.hutool.core.date.DateUtil;
import java.util.Date;
import java.util.List;
import net.risesoft.api.persistence.dao.job.JobInfoDao;
import net.risesoft.api.persistence.job.JobInfoService;
import net.risesoft.api.persistence.model.job.JobInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class JobInfoServiceImpl
implements JobInfoService {
    @Autowired
    JobInfoDao dao;
    private String date;

    @Override
    public Long getCount(String environment) {
        return this.dao.getCount(environment);
    }

    @Override
    public List<JobInfo> getInfo(String environment, String startTime, String endTime) {
        return this.dao.search(environment, startTime, endTime);
    }

    private String getDate() {
        if (this.date == null) {
            this.refresh();
        }
        return this.date;
    }

    @Scheduled(cron="0 0,1 0 1/1 * ?")
    private void refresh() {
        this.date = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
    }

    @Override
    public void addSuccess(String environment) {
        if (this.dao.addSuccess(this.getDate(), environment) < 1) {
            this.create(environment);
            this.dao.addSuccess(this.getDate(), environment);
        }
    }

    private void create(String environment) {
        this.dao.create(this.getDate(), environment);
    }

    @Override
    public void addError(String environment) {
        if (this.dao.addError(this.getDate(), environment) < 1) {
            this.create(environment);
            this.dao.addError(this.getDate(), environment);
        }
    }
}

