/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.persistence.iservice.impl;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.risedata.register.service.IServiceInstance;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class LocalFileIServiceImpl {
    private Map<String, IServiceInstance> instanceMap = new ConcurrentHashMap<String, IServiceInstance>();
    @Value(value="${register.discovery.repository:}")
    String repository;

    public void toFile() {
        this.saveInfo(JSON.toJSONString(this.instanceMap));
    }

    public void saveInfo(String info) {
        if (!StringUtils.isEmpty((Object)this.repository)) {
            FileUtil.writeString((String)info, (File)new File(this.repository), (String)"UTF-8");
        }
    }

    public void delById(String id) {
        if (this.instanceMap.remove(id) != null) {
            this.toFile();
        }
    }

    public void save(IServiceInstance serviceInstance) {
        this.instanceMap.put(serviceInstance.getInstanceId(), serviceInstance);
        this.toFile();
    }

    public List<IServiceInstance> getAll() {
        ArrayList<IServiceInstance> iServiceInstances = new ArrayList<IServiceInstance>();
        String strs = FileUtil.readUtf8String((String)this.repository);
        if (!StringUtils.isEmpty((Object)strs)) {
            JSONObject datas = JSON.parseObject((String)strs);
            for (String key : datas.keySet()) {
                IServiceInstance iServiceInstance = (IServiceInstance)datas.getObject(key, IServiceInstance.class);
                this.instanceMap.put(key, iServiceInstance);
                iServiceInstances.add(iServiceInstance);
            }
        }
        return iServiceInstances;
    }
}

