/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.persistence.iservice.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.commons.map.LMap;
import net.risedata.jdbc.service.impl.AutomaticCrudService;
import net.risedata.register.service.IServiceInstanceFactory;
import net.risesoft.api.listener.ClientListener;
import net.risesoft.api.message.MessageService;
import net.risesoft.api.persistence.dao.IServiceDao;
import net.risesoft.api.persistence.iservice.IServiceService;
import net.risesoft.api.persistence.model.IServiceInstanceModel;
import net.risesoft.api.utils.MapUtils;
import net.risesoft.api.utils.SqlUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;

public class DataBaseIServiceService
extends AutomaticCrudService<IServiceInstanceModel, String>
implements IServiceService {
    private Object saveLock = new Object();
    @Autowired
    MessageService messageService;
    @Autowired
    IServiceDao iServiceDao;
    @Autowired
    IServiceInstanceFactory iServiceInstanceFactory;
    @Value(value="${beta.service.checkEnable:false}")
    private boolean isExpire;

    @Override
    public boolean delById(String id) {
        IServiceInstanceModel model = this.findById(id);
        if (model != null) {
            this.deleteById(id);
            this.sendModel(model);
            return true;
        }
        return false;
    }

    @Override
    public boolean instanceClose(String id) {
        IServiceInstanceModel model = this.findById(id);
        if (model != null && model.getStatus() == 0) {
            this.deleteById(id);
            this.sendModel(model);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveModel(IServiceInstanceModel serviceInstance) {
        Integer status = this.iServiceDao.findStatus(serviceInstance.getInstanceId());
        boolean res = false;
        if (status == null) {
            Object object = this.saveLock;
            synchronized (object) {
                try {
                    status = this.iServiceDao.findStatus(serviceInstance.getInstanceId());
                    if (status == null) {
                        if (serviceInstance.getWatchServer() == null) {
                            serviceInstance.setWatchServer("");
                        }
                        this.insert(serviceInstance);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (status == 3) {
            serviceInstance.setStatus(0);
        } else {
            serviceInstance.setStatus(status);
        }
        this.updateById(serviceInstance);
        res = true;
        this.sendModel(serviceInstance);
        return res;
    }

    private boolean sendModel(IServiceInstanceModel serviceInstance) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (serviceInstance.getStatus() == 0) {
            map.put("instance", serviceInstance);
            map.put("environment", serviceInstance.getEnvironment());
            ClientListener.pushListener("CLOUD_REGISTER_REGISTER_LISTENER", map, null, null, serviceInstance.getEnvironment());
            return true;
        }
        if (serviceInstance.getStatus() != 3) {
            this.messageService.onServiceDown(serviceInstance);
        }
        map.put("serviceId", serviceInstance.getServiceId());
        map.put("instanceId", serviceInstance.getInstanceId());
        map.put("environment", serviceInstance.getEnvironment());
        ClientListener.pushListener("CLOUD_REGISTER_REMOVE_LISTENER", map, null, null, serviceInstance.getEnvironment());
        return false;
    }

    private boolean sendRemove(IServiceInstanceModel serviceInstance) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceId", serviceInstance.getServiceId());
        map.put("instanceId", serviceInstance.getInstanceId());
        map.put("environment", serviceInstance.getEnvironment());
        ClientListener.pushListener("CLOUD_REGISTER_REMOVE_LISTENER", map, null, null, serviceInstance.getEnvironment());
        return false;
    }

    @Override
    public Map<String, List<IServiceInstanceModel>> getUseAll(String environment) {
        return MapUtils.createMaps(this.iServiceDao.findByStatus(0, environment, this.iServiceInstanceFactory.getIsntance().getServiceId()), is -> is.getServiceId());
    }

    @Override
    public IServiceInstanceModel findById(String id) {
        return this.iServiceDao.findById(id);
    }

    @Override
    public IServiceInstanceModel findWatchById(String id) {
        return this.iServiceDao.findWatchById(id, this.iServiceInstanceFactory.getIsntance().getInstanceId());
    }

    @Override
    public Integer updateNowTime(String id) {
        return this.iServiceDao.updateNowTime(id, System.currentTimeMillis());
    }

    @Override
    public List<String> getServices(String environment) {
        return this.iServiceDao.getServices(environment);
    }

    @Override
    public List<IServiceInstanceModel> getService(String name, String environment) {
        return this.iServiceDao.getServicesByName(name, environment);
    }

    @Override
    public boolean setStatus(String id, int status) {
        boolean res;
        boolean bl = res = this.iServiceDao.updateStatus(id, status) != 0;
        if (res) {
            this.sendModel(this.findById(id));
        }
        return res;
    }

    @Override
    public List<IServiceInstanceModel> findWatch(String watchServer, String environment, String serviceId) {
        return this.iServiceDao.findWatch(watchServer, environment, serviceId);
    }

    @Override
    public boolean updateWatch(String instanceId, String watchServer, String id) {
        return this.iServiceDao.updateWatch(instanceId, watchServer, id) > 0;
    }

    @Override
    public List<String> findMiss(String instanceId, String[] ids) {
        if (ids.length < 1) {
            return this.iServiceDao.findMiss(instanceId);
        }
        return this.iServiceDao.findMiss(instanceId, ids);
    }

    @Override
    public Integer updateNoWatch(String[] ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        List<String> updatedIds = this.iServiceDao.searchNoWatch(this.iServiceInstanceFactory.getIsntance().getInstanceId(), ids, this.iServiceInstanceFactory.getIsntance().getServiceId(), this.iServiceInstanceFactory.getIsntance().getEnvironment());
        if (updatedIds.isEmpty()) {
            return 0;
        }
        return this.iServiceDao.updateNoWatch(updatedIds);
    }

    @Override
    public List<String> getUseAllSearch(String environment, String service) {
        return this.iServiceDao.findByStatusAndService(0, environment, service);
    }

    @Override
    public List<String> getAllForName(String environment, String[] services) {
        return this.getSearchExecutor().searchForList(IServiceInstanceModel.class, "distinct SERVICE_Id", SqlUtils.createInlikeOperaion("serviceId", "serviceId", services, false), (Map)LMap.createMap((Object)"environment", (Object)environment), null, String.class);
    }

    @Scheduled(fixedDelayString="${beta.service.check:30000}")
    public void checkService() {
        if (!this.isExpire) {
            return;
        }
        List<IServiceInstanceModel> expiresService = this.iServiceDao.getExpiresService(System.currentTimeMillis());
        if (expiresService.size() > 0) {
            for (IServiceInstanceModel iServiceInstanceModel : expiresService) {
                this.setStatus(iServiceInstanceModel.getInstanceId(), 2);
            }
        }
    }

    @Override
    public List<IServiceInstanceModel> findAll(Integer status, String environment) {
        if (status == null) {
            return this.iServiceDao.findAll(environment);
        }
        return this.iServiceDao.findAll(status, environment);
    }
}

