/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.persistence.config.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.builder.OperationBuilder;
import net.risedata.jdbc.commons.LPage;
import net.risedata.jdbc.commons.map.LMap;
import net.risedata.jdbc.commons.map.MapPack;
import net.risedata.jdbc.factory.OperationBuilderFactory;
import net.risedata.jdbc.operation.Operation;
import net.risedata.jdbc.operation.impl.CustomOperation;
import net.risedata.jdbc.search.LPageable;
import net.risedata.jdbc.service.impl.AutomaticCrudService;
import net.risesoft.api.exceptions.ServiceOperationException;
import net.risesoft.api.persistence.config.ConfigHisService;
import net.risesoft.api.persistence.config.ConfigService;
import net.risesoft.api.persistence.dao.ConfigDao;
import net.risesoft.api.persistence.log.LogService;
import net.risesoft.api.persistence.model.config.Config;
import net.risesoft.api.persistence.model.config.ConfigHis;
import net.risesoft.api.persistence.model.log.Log;
import net.risesoft.api.utils.AutoIdUtil;
import net.risesoft.api.utils.PropertiesUtil;
import net.risesoft.y9public.entity.DataTaskMakeUpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class ConfigServiceImpl
extends AutomaticCrudService<Config, String>
implements ConfigService {
    @Autowired
    ConfigHisService configHisService;
    @Autowired
    ConfigDao configDao;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigServiceImpl.class);
    @Autowired
    LogService logService;

    @Override
    @Transactional
    public void saveConfig(Config config) {
        String id = this.configDao.find(config.getName(), config.getGroup(), config.getEnvironment());
        if (id != null && !id.equals(config.getId())) {
            throw new ServiceOperationException("\u552f\u4e00id \u91cd\u590d\u5df2\u5b58\u5728 \u8be5\u914d\u7f6e\u6587\u4ef6");
        }
        if (StringUtils.isEmpty((Object)config.getId())) {
            config.setId(AutoIdUtil.getRandomId26());
            config.setCreateDate(new Date());
            config.setUpdateDate(new Date());
            this.configHisService.saveConfig(config, "\u65b0\u589e");
            this.insert(config);
        } else {
            config.setUpdateDate(new Date());
            this.configHisService.saveConfig(config, "\u4fee\u6539");
            this.updateById(config);
        }
    }

    @Override
    public List<String> findIdAll(String[] groups, String[] configs, String environment) {
        return this.configDao.findIdAll(groups, configs, environment);
    }

    @Override
    public LPage<Map<String, Object>> search(Config config, LPageable pageable) {
        return this.getSearchExecutor().searchForPage((Object)config, "ID id,NAME name,TYPE config_type,GROUP_NAME config_group,CREATE_DATE,UPDATE_DATE,ENVIRONMENT environment,DESCRIPTION DESCRIPTION", pageable);
    }

    @Override
    public void delConfigById(String id) {
        Config config = new Config();
        config.setId(id);
        this.delete(config);
    }

    @Override
    public boolean back(String hisId, String id) {
        ConfigHis his = this.configHisService.findOne(hisId);
        if (his == null) {
            throw new ServiceOperationException(" \u5386\u53f2\u7248\u672c \u4e0d\u5b58\u5728!");
        }
        Config current = (Config)this.getOne(id);
        if (current == null) {
            throw new ServiceOperationException(" \u5f53\u524d\u914d\u7f6e\u6587\u4ef6 \u4e0d\u5b58\u5728!");
        }
        current.setContent(his.getContent());
        this.updateById(current);
        return true;
    }

    @Override
    public List<Config> findByIds(String[] ids) {
        OperationBuilder operationMap = OperationBuilderFactory.builder((String)"id", (Operation)new CustomOperation(where -> {
            where.append((CharSequence)"id in (");
            for (int i = 0; i < ids.length; ++i) {
                if (i != 0) {
                    where.append((CharSequence)",?");
                } else {
                    where.append((CharSequence)"?");
                }
                where.add((Object)ids[i]);
            }
            where.append((CharSequence)")");
            return true;
        }));
        return this.search("*", null, (Map)operationMap);
    }

    @Override
    public Map<String, Object> getConfigMap(String[] groups, String[] configs, String environment, String serviceId, String ipAddress, boolean append) {
        List<Config> configList = this.configDao.findAll(groups, configs, environment);
        Log log = new Log();
        String configStr = Arrays.toString(configs);
        log.setIp(ipAddress);
        log.setContext(serviceId + "\u83b7\u53d6\u4e86:" + configStr + "\u5206\u7ec4\u4e3a:" + Arrays.toString(groups));
        log.setType("CONFIG_LOG");
        log.setInsId(configStr);
        log.setEnvironment(environment);
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String group : groups) {
            for (String config : configs) {
                for (Config config1 : configList) {
                    if (!config1.getName().equals(config) || !config1.getGroup().equals(group)) continue;
                    try {
                        Map<String, Object> tempMap = PropertiesUtil.getMap(config1);
                        tempMap.forEach((k, v) -> {
                            if (append) {
                                Object value = result.get(k);
                                if (StringUtils.isEmpty(value)) {
                                    result.put((String)k, v);
                                } else {
                                    value = value + "," + v;
                                    result.put((String)k, value);
                                }
                            } else {
                                result.put((String)k, v);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LOGGER.error(config1.getName() + "error: " + e.getMessage());
                        throw new ServiceOperationException(config1.getName() + e.getMessage());
                    }
                }
            }
        }
        this.logService.addLog(log, ipAddress);
        return result;
    }

    @Override
    @Transactional
    public boolean syncEnvironment(String sourceConfigIds, String toEnvironment) {
        String[] sourceConfigIdes;
        for (String sourceConfigId : sourceConfigIdes = sourceConfigIds.split(",")) {
            Config config = (Config)this.getOne(sourceConfigId);
            if (config == null) {
                throw new ServiceOperationException("\u4e0d\u5b58\u5728\u7684\u914d\u7f6e\u6587\u4ef6");
            }
            String ovlId = this.configDao.find(config.getName(), config.getGroup(), toEnvironment);
            config.setEnvironment(toEnvironment);
            config.setId(null);
            if (ovlId != null) {
                config.setId(ovlId);
            }
            this.saveConfig(config);
        }
        return true;
    }

    @Override
    public Config findOneNoSecurity(String id) {
        return (Config)this.findById(new String[]{id});
    }

    @Override
    public Config findOneNoSecurity(String name, String environment) {
        return this.configDao.find(name, environment);
    }

    @Override
    public void refreshConfig(String jobId, String taskName) {
        DataTaskMakeUpEntity dataTaskMakeUpEntity = new DataTaskMakeUpEntity();
        dataTaskMakeUpEntity.setTaskId(jobId);
        List dataTaskMakeUpEntitys = this.getSearchExecutor().searchForList((Object)dataTaskMakeUpEntity, DataTaskMakeUpEntity.class);
        ArrayList<Map<String, Object>> jobs = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> plugs = new ArrayList<Map<String, Object>>();
        MapPack coreMap = LMap.createMap(Object.class).pu((Object)"channel", new HashMap()).pu((Object)"exchange", new HashMap()).pu((Object)"executor", new HashMap()).pu((Object)"plugs", plugs);
        Map jobMap = LMap.toMap((String)"core", (Object)coreMap, (String)"job", jobs);
        if (dataTaskMakeUpEntitys.size() <= 1) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u591f\u7f3a\u5931\u914d\u7f6e\u53c2\u6570!");
        }
        ArrayList<Object> plugEntitys = new ArrayList<Object>();
        for (Object dataTaskMakeUpEntity2 : dataTaskMakeUpEntitys) {
            switch (((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getTypeName()) {
                case "job.input": {
                    this.getMap(jobs, ((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getTabIndex() - 1).put("input", LMap.toMap((String)"name", (Object)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getNameValue(), (String)"args", (Object)JSON.parse((String)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getArgsValue())));
                    break;
                }
                case "job.output": {
                    this.getMap(jobs, ((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getTabIndex() - 1).put("output", LMap.toMap((String)"name", (Object)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getNameValue(), (String)"args", (Object)JSON.parse((String)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getArgsValue())));
                    break;
                }
                case "channel.output": {
                    ((Map)coreMap.get("channel")).put("output", LMap.toMap((String)"name", (Object)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getNameValue(), (String)"args", (Object)JSON.parse((String)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getArgsValue())));
                    break;
                }
                case "channel.input": {
                    ((Map)coreMap.get("channel")).put("input", LMap.toMap((String)"name", (Object)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getNameValue(), (String)"args", (Object)JSON.parse((String)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getArgsValue())));
                    break;
                }
                case "exchange": {
                    ((Map)coreMap.get("exchange")).put("name", ((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getNameValue());
                    ((Map)coreMap.get("exchange")).put("args", JSON.parse((String)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getArgsValue()));
                    break;
                }
                case "executor.input": {
                    ((Map)coreMap.get("executor")).put("input", LMap.toMap((String)"name", (Object)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getNameValue(), (String)"args", (Object)JSON.parse((String)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getArgsValue())));
                    break;
                }
                case "executor.output": {
                    ((Map)coreMap.get("executor")).put("output", LMap.toMap((String)"name", (Object)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getNameValue(), (String)"args", (Object)JSON.parse((String)((DataTaskMakeUpEntity)((Object)dataTaskMakeUpEntity2)).getArgsValue())));
                    break;
                }
                case "plugs": {
                    plugEntitys.add(dataTaskMakeUpEntity2);
                    break;
                }
            }
        }
        plugEntitys.sort(Comparator.comparingInt(DataTaskMakeUpEntity::getTabIndex));
        int plugCurrentIndex = 1;
        for (Object entity : plugEntitys) {
            ((DataTaskMakeUpEntity)((Object)entity)).setTabIndex(plugCurrentIndex++);
        }
        for (DataTaskMakeUpEntity dataTaskMakeUpEntity2 : plugEntitys) {
            Map<String, Object> plugMap = this.getMap(plugs, dataTaskMakeUpEntity2.getTabIndex() - 1);
            plugMap.put("name", dataTaskMakeUpEntity2.getNameValue());
            plugMap.put("args", JSON.parse((String)dataTaskMakeUpEntity2.getArgsValue()));
        }
        Config config = new Config();
        config.setId(jobId);
        config.setCreateDate(new Date());
        config.setContent(JSON.toJSONString((Object)jobMap));
        config.setType("json");
        config.setName(taskName);
        config.setDescription(taskName);
        config.setUpdateDate(new Date());
        config.setGroup("job");
        this.save(config);
    }

    private Map<String, Object> getMap(List<Map<String, Object>> maps, int index) {
        if (maps.size() <= index) {
            for (int i = 0; i < index - maps.size() + 1; ++i) {
                maps.add(new HashMap());
            }
        }
        return maps.get(index);
    }
}

