/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risedata.rpc.provide.listener.Listener;
import net.risedata.rpc.provide.net.ClinetConnection;
import net.risesoft.api.persistence.iservice.IServiceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ClientListener
implements Listener {
    private static final Logger LOG = LoggerFactory.getLogger(ClientListener.class);
    public static final List<ClinetConnection> connections = new ArrayList<ClinetConnection>();
    @Autowired
    IServiceService iServiceService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnection(ClinetConnection clinetConnection) {
        if (LOG.isInfoEnabled()) {
            LOG.info(clinetConnection.getRemoteAddress() + "connection ");
        }
        List<ClinetConnection> list = connections;
        synchronized (list) {
            connections.add(clinetConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed(ClinetConnection clinetConnection) {
        if (LOG.isInfoEnabled()) {
            LOG.info(clinetConnection.getRemoteAddress() + "\u8fde\u63a5\u5173\u95ed ");
        }
        List<ClinetConnection> list = connections;
        synchronized (list) {
            connections.remove(clinetConnection);
        }
        Object name = clinetConnection.getAttribute("CONNECTION_INSTANCE_NAME");
        Object id = clinetConnection.getAttribute("CONNECTION_INSTANCE_ID");
        if (id != null && name != null) {
            this.iServiceService.instanceClose(id.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClinetConnection getConnection(String instanceId) {
        List<ClinetConnection> list = connections;
        synchronized (list) {
            for (ClinetConnection connection : connections) {
                if (!instanceId.equals(connection.getAttribute("CONNECTION_INSTANCE_ID"))) continue;
                return connection;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushListener(String name, Map<String, Object> value, String serviceName, String instanceId, String environment) {
        HashMap<Object, Boolean> sendedMap = new HashMap<Object, Boolean>();
        List<ClinetConnection> list = connections;
        synchronized (list) {
            for (ClinetConnection connection : connections) {
                try {
                    if (environment != null && !environment.equals(connection.getAttribute("INSTANCE_ENVIRONMENT_NAME")) || serviceName != null && !serviceName.equals(connection.getAttribute("CONNECTION_INSTANCE_NAME")) || instanceId != null && !instanceId.equals(connection.getAttribute("CONNECTION_INSTANCE_ID")) || sendedMap.containsKey(connection.getAttribute("CONNECTION_INSTANCE_ID"))) continue;
                    sendedMap.put(connection.getAttribute("CONNECTION_INSTANCE_ID"), true);
                    connection.pushListener(name, value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOG.error("\u53d1\u9001\u4e8b\u4ef6\u5931\u8d25:" + name + e.getMessage());
                }
            }
        }
    }
}

