/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.job.actions.dispatch.method;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import net.risesoft.api.exceptions.JobException;
import net.risesoft.api.job.JobContext;
import net.risesoft.api.job.TaskExecutorService;
import net.risesoft.api.job.actions.JobAction;
import net.risesoft.api.job.actions.dispatch.DispatchJobAction;
import net.risesoft.api.job.actions.dispatch.method.impl.AssignAction;
import net.risesoft.api.job.creator.JobArgsCreator;
import net.risesoft.api.persistence.model.job.Job;
import net.risesoft.api.persistence.model.job.JobLog;
import net.risesoft.api.utils.LResult;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DispatchActionManager
implements JobAction {
    @Autowired
    Map<String, DispatchJobAction> dispatchJobActionMap;
    @Autowired
    AssignAction assignAction;
    @Autowired
    JobArgsCreator jobArgsCreator;
    public static final String DISPATCH_ARGS = "DISPATCH_ARGS";
    public static final String INSTANCE_SIZE = "$instanceSize";

    @Override
    public LResult action(Job job, JobLog jobLog, TaskExecutorService taskExecutor, JobContext jobContext) {
        JobAction jobAction = this.dispatchJobActionMap.get(job.getDispatchMethod());
        if (!StringUtils.isEmpty((CharSequence)job.getDispatchArgs())) {
            jobContext.put(DISPATCH_ARGS, JSON.parse((String)this.jobArgsCreator.creator(jobContext, job.getDispatchArgs())));
        }
        if (jobAction != null) {
            taskExecutor.appendLog(jobLog.getId(), "\u5f00\u59cb\u6267\u884c:" + job.getDispatchMethod() + "\u8c03\u5ea6\u65b9\u5f0f!");
            return jobAction.action(job, jobLog, taskExecutor, jobContext);
        }
        throw new JobException("\u672a\u77e5\u7684\u8c03\u5ea6\u65b9\u5f0f:" + job.getDispatchMethod());
    }
}

