/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.job.actions.dispatch.executor;

import java.util.Map;
import net.risesoft.api.exceptions.JobException;
import net.risesoft.api.job.JobContext;
import net.risesoft.api.job.TaskExecutorService;
import net.risesoft.api.job.actions.dispatch.CountResult;
import net.risesoft.api.job.actions.dispatch.ExecutorAction;
import net.risesoft.api.job.actions.dispatch.executor.DoBalance;
import net.risesoft.api.job.actions.dispatch.executor.Result;
import net.risesoft.api.job.creator.JobArgsCreator;
import net.risesoft.api.persistence.model.job.Job;
import net.risesoft.api.persistence.model.job.JobLog;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.stereotype.Component;

@Component
public class ExecutorActionManager
implements ExecutorAction {
    @Autowired
    Map<String, ExecutorAction> executorJobActionMap;
    @Autowired
    TaskExecutorService taskExecutorService;
    @Autowired
    JobArgsCreator jobArgsCreator;

    @Override
    public Result action(Job job, JobLog jobLog, Map<String, Object> args, ServiceInstance iServiceInstance, JobContext jobContext, DoBalance doBalance) {
        String type = job.getType();
        ExecutorAction executorAction = this.executorJobActionMap.get(type);
        if (!StringUtils.isEmpty((CharSequence)job.getArgs())) {
            args.put("args", this.jobArgsCreator.creator(jobContext, job.getArgs()));
        }
        if (executorAction != null) {
            if (job.getErrorCount() != null && job.getErrorCount() > 0) {
                ServiceInstance[] tempService = new ServiceInstance[]{iServiceInstance};
                return new CountResult(job.getErrorCount(), (count, err) -> {
                    if (doBalance != null && err != null) {
                        tempService[0] = doBalance.doBalance(count, tempService[0]);
                    }
                    this.taskExecutorService.appendSource(jobLog.getId(), tempService[0].getInstanceId(), err != null ? "\u5f02\u5e38\u4fe1\u606f" + err.getMessage() + "\n \u8c03\u5ea6\u5931\u8d25\u5f00\u59cb\u91cd\u8bd5:" + (job.getErrorCount() - count) : "\u5f00\u59cb\u6267\u884c\u8c03\u5ea6:" + type);
                    return executorAction.action(job, jobLog, args, tempService[0], jobContext, doBalance);
                });
            }
            this.taskExecutorService.appendSource(jobLog.getId(), iServiceInstance.getInstanceId(), "\u5f00\u59cb\u6267\u884c\u8c03\u5ea6:" + type);
            return executorAction.action(job, jobLog, args, iServiceInstance, jobContext, doBalance);
        }
        throw new JobException("\u672a\u77e5\u7684\u8c03\u5ea6\u7c7b\u578b:" + type);
    }
}

