/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.job;

import cn.hutool.core.date.DateUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.risedata.register.service.IServiceInstanceFactory;
import net.risesoft.api.exceptions.JobException;
import net.risesoft.api.job.JobContext;
import net.risesoft.api.job.TaskManager;
import net.risesoft.api.job.actions.JobAction;
import net.risesoft.api.job.actions.start.StartJobAction;
import net.risesoft.api.job.actions.start.StartJobChildrenAction;
import net.risesoft.api.message.MessageService;
import net.risesoft.api.persistence.job.JobLogService;
import net.risesoft.api.persistence.model.job.Job;
import net.risesoft.api.persistence.model.job.JobLog;
import net.risesoft.api.utils.LResult;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class TaskExecutorService
implements ApplicationContextAware,
DisposableBean {
    @Autowired
    TaskManager taskManager;
    @Autowired
    JobLogService jobLogService;
    @Autowired
    IServiceInstanceFactory iServiceInstanceFactory;
    @Autowired
    List<JobAction> actions;
    private Map<Class<?>, JobAction> jobActionMap = new ConcurrentHashMap();
    private Map<Integer, List<String>> jobLogMap = new ConcurrentHashMap<Integer, List<String>>();
    public static final String SERVER_KEY = "$server";
    @Autowired
    MessageService messageService;

    public TaskManager getTaskManager() {
        return this.taskManager;
    }

    public JobLogService getJobLogService() {
        return this.jobLogService;
    }

    public void appendLog(String logId, String context) {
        this.jobLogService.appendLog(logId, context);
    }

    private synchronized void addLog(Integer jobId, String logId) {
        List<String> logs = this.jobLogMap.get(jobId);
        if (logs == null) {
            logs = new ArrayList<String>();
            this.jobLogMap.put(jobId, logs);
        }
        logs.add(logId);
    }

    private synchronized void removeLog(Integer jobId, String logId) {
        List<String> logs = this.jobLogMap.get(jobId);
        if (logs != null) {
            logs.remove(logId);
            if (logs.size() == 0) {
                this.jobLogMap.remove(jobId);
            }
        }
    }

    public synchronized List<String> getLogs(Integer jobId) {
        return this.jobLogMap.get(jobId);
    }

    public String startJob(Job job) {
        return this.startJob(job, null);
    }

    public String startJob(Job job, String server) {
        JobLog jobLog = new JobLog();
        jobLog.setStatus(0);
        jobLog.setEnvironment(job.getEnvironment());
        jobLog.setChildJobId(job.getChildJobs());
        jobLog.setDispatchSource("");
        jobLog.setJobId(job.getId());
        jobLog.setDispatchServer(this.iServiceInstanceFactory.getIsntance().getInstanceId());
        jobLog.setLogConsole(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss") + " start job \n");
        this.jobLogService.saveLog(jobLog);
        this.addLog(job.getId(), jobLog.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)server)) {
            map.put(SERVER_KEY, server);
        }
        try {
            this.toAction(StartJobAction.class, job, jobLog, new JobContext(map));
        }
        catch (Exception e) {
            jobLog.setStatus(2);
            this.jobLogService.updateStatus(jobLog.getId(), 2);
            this.removeLog(job.getId(), jobLog.getId());
            this.jobLogService.appendLog(jobLog.getId(), "\u6267\u884c\u4efb\u52a1\u5931\u8d25\u5f02\u5e38\u4fe1\u606f:\n" + TaskExecutorService.getExceptionStack(e).substring(0, 250));
        }
        return jobLog.getId();
    }

    public void startJob(Job job, JobLog jobLog, JobContext jobContext) {
        if (jobContext == null) {
            jobContext = new JobContext(new HashMap<String, Object>());
        }
        try {
            this.jobLogService.updateStatus(jobLog.getId(), 0, jobLog.getStatus());
            jobLog.setStatus(0);
            this.addLog(job.getId(), jobLog.getId());
            this.toAction(StartJobAction.class, job, jobLog, jobContext);
        }
        catch (Exception e) {
            this.endJob(job, jobLog, 2, "\u6267\u884c\u4efb\u52a1\u5931\u8d25\u5f02\u5e38\u4fe1\u606f:\n" + e.getMessage(), jobContext);
        }
    }

    public static String getExceptionStack(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    public void endJob(Job job, JobLog jobLog, Integer status, String msg, String result, JobContext jobContext) {
        if (jobContext.isChildrenJob()) {
            this.appendLog(jobLog.getId(), "\u4efb\u52a1<<" + (job.getId() + job.getName() + "(" + job.getDescription() + ")") + (">>\u6267\u884c\u7ed3\u675f\n\u6267\u884c\u72b6\u6001:" + (status == 1 ? "\u6210\u529f" : "\u5931\u8d25") + "\n\u6d88\u606f:" + msg + "\n\u8fd4\u56de\u503c:" + result));
            if (status == 2) {
                this.closeJob(job, jobLog, status, msg, result, jobContext);
            }
        } else {
            this.closeJob(job, jobLog, status, msg, result, jobContext);
        }
    }

    private void closeJob(Job job, JobLog jobLog, Integer status, String msg, String result, JobContext jobContext) {
        this.jobLogService.endJob(jobLog.getId(), status, msg, result, job.getEnvironment());
        this.taskManager.endJob(job, jobLog.getJobId());
        this.removeLog(job.getId(), jobLog.getId());
        if (status == 2) {
            this.messageService.onJobError(job);
        }
        this.messageService.onJobEnd(job, jobLog);
    }

    public void endJob(Job job, JobLog jobLog, Integer status, String msg, JobContext jobContext) {
        this.endJob(job, jobLog, status, msg, msg, jobContext);
    }

    public void successJob(Job job, JobLog jobLog, String msg, String result, JobContext jobContext) {
        if (!StringUtils.isEmpty((CharSequence)job.getChildJobs())) {
            try {
                this.toAction(StartJobChildrenAction.class, job, jobLog, jobContext).onEnd(success -> this.endJob(job, jobLog, 1, msg, result, jobContext));
            }
            catch (Exception e) {
                this.endJob(job, jobLog, 2, "\u5b50\u4efb\u52a1\u6267\u884c\u5931\u8d25\u7cfb\u7edf\u5f02\u5e38:" + e.getMessage(), result, jobContext);
            }
        } else {
            this.endJob(job, jobLog, 1, msg, result, jobContext);
        }
    }

    public LResult toAction(Class<? extends JobAction> actionClass, Job job, JobLog jobLog, JobContext jobContext) {
        JobAction jobAction = this.jobActionMap.get(actionClass);
        if (jobAction == null) {
            throw new JobException("\u4e0d\u5b58\u5728\u7684\u6b65\u9aa4:" + actionClass);
        }
        return jobAction.action(job, jobLog, this, jobContext);
    }

    public <T> T getAction(Class<T> actionClass) {
        JobAction jobAction = this.jobActionMap.get(actionClass);
        if (jobAction == null) {
            throw new JobException("\u4e0d\u5b58\u5728\u7684\u6b65\u9aa4:" + actionClass);
        }
        return actionClass.cast(jobAction);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        for (JobAction action : this.actions) {
            this.jobActionMap.put(action.getClass(), action);
        }
    }

    public void appendSource(String id, String source, String msg) {
        this.jobLogService.appendSource(id, source, msg);
    }

    public void destroy() throws Exception {
        this.jobLogMap.clear();
    }
}

