/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.y9public.repository.spec;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.risesoft.y9public.entity.DataBusinessEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class DataBusinessSpecification
implements Specification<DataBusinessEntity> {
    private static final long serialVersionUID = -8033435846816389785L;
    private List<String> ids;
    private String parentId;
    private String name;

    public DataBusinessSpecification() {
    }

    public DataBusinessSpecification(String parentId, String name, List<String> ids) {
        this.parentId = parentId;
        this.name = name;
        this.ids = ids;
    }

    public Predicate toPredicate(Root<DataBusinessEntity> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        Predicate predicate = cb.conjunction();
        List expressions = predicate.getExpressions();
        if (StringUtils.isNotBlank((CharSequence)this.parentId)) {
            expressions.add(cb.equal(root.get("parentId").as(String.class), (Object)this.parentId));
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            expressions.add(cb.like(root.get("name").as(String.class), "%" + this.name + "%"));
        }
        if (this.ids != null && this.ids.size() > 0) {
            expressions.add(root.get("id").in(this.ids));
        }
        return predicate;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

