/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.risedata.jdbc.commons.utils.DateUtils;
import net.risesoft.api.utils.NextTime;
import org.springframework.scheduling.support.CronSequenceGenerator;

public class TaskUtils {
    private static final long ONETIME = 86399999L;

    public static List<String> getDateForOne(NextTime next, String format) {
        Date start = null;
        try {
            start = DateUtils.parse((String)DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Date date = new Date(start.getTime());
        ArrayList<String> res = new ArrayList<String>();
        SimpleDateFormat dataFormat = new SimpleDateFormat(format == null ? "dd HH:mm" : format);
        while (date.getTime() - start.getTime() - 86399999L < 0L) {
            if ((date = next.next(date)).getTime() - start.getTime() - 86399999L >= 0L) continue;
            res.add(dataFormat.format(date));
        }
        return res;
    }

    public static List<String> getDayTaskOfSpped(int speed, String format) throws ParseException {
        int speedTime = speed * 1000;
        return TaskUtils.getDateForOne(date -> new Date(date.getTime() + (long)speedTime), format);
    }

    public static List<String> getDayTaskOfCron(String cron, String format) throws ParseException {
        CronSequenceGenerator cronSequenceGenerator = new CronSequenceGenerator(cron);
        return TaskUtils.getDateForOne(date -> cronSequenceGenerator.next(date), format);
    }
}

