/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.risesoft.api.persistence.model.security.DataUser;
import net.risesoft.api.persistence.model.security.Role;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9public.repository.DataBusinessRepository;
import org.apache.commons.lang3.StringUtils;

public class ConcurrentSecurity {
    private DataUser user;
    private List<String> jobTypes;
    private List<String> environments;
    private boolean userManager;
    private boolean systemManager;

    public ConcurrentSecurity(DataUser user, List<Role> roles) {
        try {
            this.user = user;
            ArrayList<String> environments = new ArrayList<String>();
            ArrayList<String> jobTypes = new ArrayList<String>();
            for (Role role : roles) {
                if (StringUtils.isNotBlank((CharSequence)role.getEnvironments())) {
                    environments.addAll(Arrays.asList(role.getEnvironments().split(",")));
                }
                if (StringUtils.isNotBlank((CharSequence)role.getJobTypes())) {
                    DataBusinessRepository dataBusinessRepository = (DataBusinessRepository)Y9Context.getBean((String)"dataBusinessRepository");
                    String[] ids = role.getJobTypes().split(",");
                    jobTypes.addAll(Arrays.asList(ids));
                    for (String id : ids) {
                        jobTypes.addAll(dataBusinessRepository.findByParentId(id));
                    }
                }
                if (role.getSystemManager() == 1) {
                    this.systemManager = true;
                }
                if (role.getUserManager() != 1) continue;
                this.userManager = true;
            }
            this.environments = environments;
            this.jobTypes = jobTypes;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DataUser getUser() {
        return this.user;
    }

    public List<String> getJobTypes() {
        return this.jobTypes;
    }

    public List<String> getEnvironments() {
        return this.environments;
    }

    public boolean isUserManager() {
        return this.userManager;
    }

    public boolean isSystemManager() {
        return this.systemManager;
    }
}

