/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.persistence.security.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.commons.LPage;
import net.risedata.jdbc.search.LPageable;
import net.risedata.jdbc.service.impl.AutomaticCrudService;
import net.risesoft.api.persistence.model.security.NetworkWhiteList;
import net.risesoft.api.persistence.security.NetworkWhiteListService;
import net.risesoft.api.utils.AutoIdUtil;
import net.risesoft.api.utils.PattenUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class NetworkWhiteListServiceImpl
extends AutomaticCrudService<NetworkWhiteList, String>
implements NetworkWhiteListService {
    private Map<String, List<NetworkWhiteList>> environmentMap;
    private Map<String, String[]> cacheMap;
    private long dataDate;
    @Value(value="${beta.whitelist.time:300}")
    private int validityDate;

    @Override
    public void saveNetworkWhiteList(NetworkWhiteList network) {
        if (StringUtils.isEmpty((CharSequence)network.getId())) {
            network.setId(AutoIdUtil.getRandomId26());
            network.setCreateDate(new Date());
            this.insert(network);
        } else {
            this.updateById(network);
        }
    }

    @Override
    public void delById(String id) {
        this.deleteById(id);
    }

    @Override
    public LPage<NetworkWhiteList> searchByNetworkWhiteList(NetworkWhiteList network, LPageable page) {
        return this.searchForPage(network, page);
    }

    @Override
    public List<NetworkWhiteList> getNetworkWhiteList(String environment) {
        this.load();
        return this.environmentMap.get(environment);
    }

    @Override
    public List<NetworkWhiteList> getNetworkWhiteListFotIP(List<NetworkWhiteList> networkWhiteLists, String ipAddress) {
        ArrayList<NetworkWhiteList> lists = new ArrayList<NetworkWhiteList>();
        for (NetworkWhiteList networkWhiteList : networkWhiteLists) {
            if (!PattenUtil.hasMatch(networkWhiteList.getIpMatch(), ipAddress)) continue;
            lists.add(networkWhiteList);
        }
        return lists;
    }

    @Override
    public List<String> joinService(List<NetworkWhiteList> networkWhiteLists) {
        ArrayList<String> service = new ArrayList<String>();
        for (NetworkWhiteList networkWhiteList : networkWhiteLists) {
            String[] split;
            for (String s : split = networkWhiteList.getService().split(",")) {
                service.add(s);
            }
        }
        return service;
    }

    @Override
    public String[] getStrs(String ipMatch) {
        String[] res = this.cacheMap.get(ipMatch);
        if (res == null) {
            res = ipMatch.split(",");
            this.cacheMap.put(ipMatch, res);
        }
        return res;
    }

    private synchronized void load() {
        if (this.environmentMap == null || System.currentTimeMillis() - this.dataDate > (long)(this.validityDate * 60 * 1000)) {
            this.environmentMap = new HashMap<String, List<NetworkWhiteList>>();
            this.cacheMap = new HashMap<String, String[]>();
            List networkWhiteLists = this.searchAll();
            for (NetworkWhiteList networkWhiteList : networkWhiteLists) {
                List<NetworkWhiteList> networkWhiteLists1 = this.environmentMap.get(networkWhiteList.getEnvironment());
                if (networkWhiteLists1 == null) {
                    networkWhiteLists1 = new ArrayList<NetworkWhiteList>();
                    this.environmentMap.put(networkWhiteList.getEnvironment(), networkWhiteLists1);
                }
                networkWhiteLists1.add(networkWhiteList);
            }
            this.dataDate = System.currentTimeMillis();
        }
    }

    @Override
    public NetworkWhiteList findById(String id) {
        return (NetworkWhiteList)this.getOne(id);
    }

    @Override
    public List<NetworkWhiteList> findAll() {
        return this.searchAll();
    }
}

