/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.persistence.dao.job;

import java.util.Date;
import java.util.List;
import java.util.Map;
import net.risedata.jdbc.annotations.repository.Modify;
import net.risedata.jdbc.annotations.repository.Search;
import net.risedata.jdbc.repository.Repository;
import net.risesoft.api.persistence.model.job.JobLog;

public interface JobLogDao
extends Repository {
    @Search(value="select count(1) from  Y9_DATASERVICE_JOB_LOG  where JOB_ID = ? and status=0 and DISPATCH_TIME > ? and ID != ?")
    public Integer isBlock(Integer var1, Long var2, String var3);

    @Search(value="select count(1) from  Y9_DATASERVICE_JOB_LOG  where JOB_ID = ? and status=0  and ID != ?")
    public Integer isBlock(Integer var1, String var2);

    @Modify(value="update Y9_DATASERVICE_JOB_LOG set LOG_CONSOLE =  concat(LOG_CONSOLE,?2) where ID = ?1")
    public Integer appendLog(String var1, String var2);

    @Modify(value="update Y9_DATASERVICE_JOB_LOG  set STATUS =?2 where ID=?1 and  STATUS =?3")
    public Integer updateStatus(String var1, Integer var2, Integer var3);

    @Modify(value="update Y9_DATASERVICE_JOB_LOG set STATUS =?2 where ID=?1 ")
    public Integer updateStatus(String var1, Integer var2);

    @Search(value="select * from  Y9_DATASERVICE_JOB_LOG where job_ID = ?1 and status=-1 and DISPATCH_TIME = (select min(DISPATCH_TIME) from Y9_DATASERVICE_JOB_LOG  where job_ID = ?1 and status = -1 )  ")
    public JobLog pollJob(Integer var1);

    @Search(value="select * from  Y9_DATASERVICE_JOB_LOG where job_ID = ?1  and status=-1 and DISPATCH_TIME = (select min(DISPATCH_TIME) from Y9_DATASERVICE_JOB_LOG  where job_ID = ?1 and status = -1 and DISPATCH_TIME >?2 )  ")
    public JobLog pollJob(Integer var1, Long var2);

    @Modify(value="update Y9_DATASERVICE_JOB_LOG set STATUS =?2 ,LOG_CONSOLE =  concat(LOG_CONSOLE,?3),END_TIME=?4,RESULT=?5  where ID=?1 and status in(-1,0)")
    public void endJob(String var1, Integer var2, String var3, Long var4, String var5);

    @Modify(value="update Y9_DATASERVICE_JOB_LOG set DISPATCH_SOURCE =  concat(DISPATCH_SOURCE,?2) ,LOG_CONSOLE =  concat(LOG_CONSOLE,?3) where ID=?1 ")
    public void appendSource(String var1, String var2, String var3);

    @Search(value="select * from Y9_DATASERVICE_JOB_LOG where status=0 and job_ID=?1 and id not in (?2) and DISPATCH_TIME=(select min(DISPATCH_TIME) from Y9_DATASERVICE_JOB_LOG where status=0 and job_ID=?1 and id not in (?2))")
    public JobLog findDownJob(Integer var1, List<String> var2);

    @Search(value="select * from Y9_DATASERVICE_JOB_LOG where status=0 and job_ID=?1  and DISPATCH_TIME=(select min(DISPATCH_TIME) from Y9_DATASERVICE_JOB_LOG where status=0 and job_ID=?1)  ")
    public JobLog findDownJob(Integer var1);

    @Search(value="select * from Y9_DATASERVICE_JOB_LOG where id=?")
    public JobLog findById(String var1);

    @Search(value="select LOG_CONSOLE from Y9_DATASERVICE_JOB_LOG where id=?")
    public String findConsoleById(String var1);

    @Modify(value="delete from Y9_DATASERVICE_JOB_LOG where DISPATCH_TIME < ?")
    public Integer clearLog(Long var1);

    @Modify(value="update Y9_DATASERVICE_JOB_LOG set LOG_CONSOLE =  concat(LOG_CONSOLE,?1),RESULT=?1,status=2,end_time=?3 where status =0 and JOB_ID in (select ID from Y9_DATASERVICE_JOB where TIME_OUT>0 and dispatch_server=?4) and dispatch_time < ?2-(select TIME_OUT*1000 from Y9_DATASERVICE_JOB where ID=JOB_ID)")
    public Integer clearTimeOutJob(String var1, Long var2, Long var3, String var4);

    @Search(value="select JOB_ID from  Y9_DATASERVICE_JOB_LOG  where status =0 and environment=?2  and JOB_ID in (select ID from Y9_DATASERVICE_JOB where TIME_OUT>0 and dispatch_server=?2 )and dispatch_time < ?1-(select TIME_OUT*1000 from Y9_DATASERVICE_JOB where ID=JOB_ID)")
    public List<Integer> searchClearTimeOutJob(Long var1, String var2);

    @Modify(value="update Y9_DATASERVICE_JOB_LOG set LOG_CONSOLE =  concat(LOG_CONSOLE,?1),RESULT=?1,status=2,end_time=?3 where status =-1 and JOB_ID in (select ID from Y9_DATASERVICE_JOB where TIME_OUT>0 and dispatch_server=?4)and dispatch_time < ?2-(select TIME_OUT*1000 from Y9_DATASERVICE_JOB where ID=JOB_ID)")
    public Integer clearTimeOutJobAndAwait(String var1, Long var2, Long var3, String var4);

    @Search(value="select count(*) from Y9_DATASERVICE_JOB_LOG where environment=?")
    public Integer getLogCount(String var1);

    @Search(value="select * from Y9_DATASERVICE_JOB_LOG where status=0 and job_ID=?1")
    public List<JobLog> findDownJobs(Integer var1);

    @Search(value="select * from Y9_DATASERVICE_JOB_LOG where status=0 and job_ID=?1 and id not in (?2)")
    public List<JobLog> findDownJobs(Integer var1, List<String> var2);

    @Modify(value="update Y9_DATASERVICE_JOB_LOG set LOG_CONSOLE =  concat(LOG_CONSOLE,?1),RESULT=?1,status=2,end_time=?3 where status=0 and JOB_ID in (select ID from Y9_DATASERVICE_JOB where TIME_OUT = 0 and dispatch_server=?4)and dispatch_time < ?2")
    public Integer clearDefaultTimeOut(String var1, Long var2, Date var3, String var4);

    @Search(value="select JOB_ID from  Y9_DATASERVICE_JOB_LOG  where status=0 and JOB_ID in (select ID from Y9_DATASERVICE_JOB where TIME_OUT = 0 and dispatch_server=?2)and dispatch_time < ?1")
    public List<Integer> searchClearDefaultTimeOut(Long var1, String var2);

    @Search(value="select * from #{?1}")
    public Map<String, Object> findRunableMinInstance(String var1);

    @Modify(value="update Y9_DATASERVICE_JOB_LOG set LOG_CONSOLE = ?2 where ID=?1 ")
    public void updateLog(String var1, String var2);

    @Modify(value="delete from Y9_DATASERVICE_JOB_LOG where job_id=? and status = -1")
    public int deleteAwaitJobLog(Integer var1);

    @Modify(value="delete from Y9_DATASERVICE_JOB_LOG where job_id=?1")
    public int deleteJobLog(Integer var1);

    @Search(value="select count(*) from  (select distinct  log_t.JOB_ID from  Y9_DATASERVICE_JOB_LOG as log_t where  status=?1) as t")
    public Integer getExecutingCount(Integer var1);

    @Search(value="select count(*) from( select distinct log_t.JOB_ID from Y9_DATASERVICE_JOB_LOG as log_t where status in (?1) and DISPATCH_TIME >=?2  and END_TIME<=?3 ) as t")
    public Integer getExecutedCountByStatusAndTime(List<Integer> var1, Long var2, Long var3);

    @Search(value="select count(*) as execute_count,DATE_FORMAT(FROM_UNIXTIME(log_t.DISPATCH_TIME/1000),'%Y-%m-%d' ) as execute_start_time from Y9_DATASERVICE_JOB_LOG as log_t where status in (?1) and DISPATCH_TIME>=?2 and DISPATCH_TIME<=?3 GROUP by execute_start_time order by execute_start_time")
    public List<Map<String, Object>> getExecutedCountGroupByDispatchTime(List<Integer> var1, Long var2, Long var3);

    @Search(value="select status , count(*) as execute_count,DATE_FORMAT(FROM_UNIXTIME(log_t.DISPATCH_TIME/1000),'%Y-%m-%d' ) as execute_start_time from Y9_DATASERVICE_JOB_LOG as log_t where status in (?1) and DISPATCH_TIME >=?2 and DISPATCH_TIME<=?3 and environment=?4 GROUP by execute_start_time ,status ")
    public List<Map<String, Object>> getSchedulingInfo(List<Integer> var1, Long var2, Long var3, String var4);

    @Search(value="select DATE_FORMAT(FROM_UNIXTIME(log_t.DISPATCH_TIME / 1000), '%Y-%m-%d') AS execute_start_time, SUM(CASE WHEN STATUS = 1 THEN 1 ELSE 0 END) AS success,SUM(CASE WHEN STATUS = 2 THEN 1 ELSE 0 END) AS failure from Y9_DATASERVICE_JOB_LOG AS log_t where status IN (?1) AND DISPATCH_TIME >= ?2 AND DISPATCH_TIME <= ?3 GROUP by execute_start_time;")
    public List<Map<String, Object>> getLogGroupInfo(List<Integer> var1, Long var2, Long var3);
}

