/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.job.log.impl;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.risedata.jdbc.service.impl.AutomaticCrudService;
import net.risesoft.api.job.log.LogAnalyseService;
import net.risesoft.api.persistence.model.log.LogAnalyse;
import net.risesoft.api.persistence.model.log.MatchAnalyseModel;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class LogMatchAnalyseService
extends AutomaticCrudService<MatchAnalyseModel, String>
implements LogAnalyseService,
ApplicationListener<ApplicationStartingEvent> {
    private Long cacheTime;
    private List<MatchAnalyseModel> matchAnalyseModels;
    @Value(value="${beta.log.time:3600}")
    private int cacheTimeOut;

    @Override
    public void doAnalyse(Integer jobId, String log, String jobName, List<LogAnalyse> logAnalyseList, Map<String, Object> map) {
        if (this.cacheTime == null || System.currentTimeMillis() - this.cacheTime > (long)this.cacheTimeOut) {
            this.loadAnalyse();
        }
        StringBuilder msg = new StringBuilder();
        for (MatchAnalyseModel matchAnalyseModel : this.matchAnalyseModels) {
            Matcher matcher = Pattern.compile(matchAnalyseModel.getMatch()).matcher(log);
            if (!matcher.find()) continue;
            int start = matcher.end();
            msg.delete(0, msg.length());
            String[] subs = matchAnalyseModel.getSubMatch().split("~~");
            for (int i = 0; i < subs.length; ++i) {
                if (LogMatchAnalyseService.isNumeric(subs[i])) {
                    msg.append(log, start, start + Integer.parseInt(subs[i]) > log.length() ? log.length() : start + Integer.parseInt(subs[i]));
                    start += Integer.parseInt(subs[i]);
                    continue;
                }
                Matcher matcher1 = Pattern.compile(subs[i]).matcher(log);
                if (!matcher1.find()) continue;
                if ((i + 1) % 2 == 0 || i == subs.length - 1) {
                    if (start == matcher.end()) {
                        start = matcher1.start();
                    }
                    msg.append(log, start, matcher1.end());
                }
                start = matcher1.start();
            }
            logAnalyseList.add(new LogAnalyse(jobId, jobName, matchAnalyseModel.getType(), msg.toString(), matchAnalyseModel.getSolution(), Integer.parseInt(map.get("JOB_END_STATUS").toString())));
            break;
        }
    }

    public static boolean isNumeric(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private synchronized void loadAnalyse() {
        if (this.cacheTime == null || System.currentTimeMillis() - this.cacheTime > this.cacheTime) {
            this.cacheTime = System.currentTimeMillis();
            this.matchAnalyseModels = this.searchAll();
        }
    }

    public void onApplicationEvent(ApplicationStartingEvent event) {
        this.cacheTimeOut *= 1000;
        System.out.println("\u8bbe\u7f6e\u65f6\u95f4");
    }
}

