/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.job.creator;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.risesoft.api.exceptions.JobException;
import net.risesoft.api.job.JobContext;
import net.risesoft.api.job.creator.CreatorMethod;
import net.risesoft.api.job.creator.JobArgsCreator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultJobArgsCreator
implements JobArgsCreator {
    private static Pattern p = Pattern.compile("\\#\\{(.*?)\\}");
    @Autowired
    private Map<String, CreatorMethod> creatorMethods;

    @Override
    public String creator(JobContext context, String creatorStr) {
        Matcher match = p.matcher(creatorStr);
        String group = null;
        while (match.find()) {
            group = match.group();
            String[] value = match.group(1).split("^");
            String[] args = null;
            CreatorMethod creatorMethod = this.creatorMethods.get(value[0]);
            if (creatorMethod == null) {
                throw new JobException("\u65b9\u6cd5\u4e0d\u5b58\u5728" + value[0]);
            }
            if (value.length > 1) {
                args = value[1].split("%%");
            }
            creatorStr = creatorStr.replace(group, creatorMethod.create(context, args));
        }
        return creatorStr;
    }
}

