/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.job.actions.dispatch.method;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.risedata.register.discover.IServiceInstanceImpl;
import net.risedata.register.service.IServiceInstance;
import net.risedata.register.service.IServiceInstanceFactory;
import net.risesoft.api.api.RegisterApi;
import net.risesoft.api.exceptions.JobException;
import net.risesoft.api.job.TaskExecutorService;
import net.risesoft.api.job.actions.dispatch.DispatchJobAction;
import net.risesoft.api.job.actions.dispatch.executor.ExecutorActionManager;
import net.risesoft.api.job.actions.dispatch.executor.Result;
import net.risesoft.api.persistence.model.IServiceInstanceModel;
import net.risesoft.api.persistence.model.job.Job;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public abstract class AbstractDispatchAction
implements DispatchJobAction {
    @Autowired
    public ExecutorActionManager executorActionManager;
    @Autowired
    public DiscoveryClient discoveryClient;
    @Autowired
    IServiceInstanceFactory iServiceInstanceFactory;
    @Autowired
    RegisterApi registerApi;

    protected List<ServiceInstance> getService(Job job) {
        ArrayList<IServiceInstanceImpl> instances = null;
        if (this.iServiceInstanceFactory.getIsntance().getEnvironment().equals(job.getEnvironment())) {
            instances = this.discoveryClient.getInstances(job.getServiceId());
        } else {
            List<IServiceInstanceModel> iServiceInstanceModels = this.registerApi.getServices(job.getEnvironment()).get(job.getService());
            if (iServiceInstanceModels != null) {
                instances = new ArrayList<IServiceInstanceImpl>();
                for (int i = 0; i < iServiceInstanceModels.size(); ++i) {
                    IServiceInstanceModel iServiceInstanceModel = iServiceInstanceModels.get(i);
                    IServiceInstance iServiceInstance = new IServiceInstance();
                    iServiceInstance.setServiceId(iServiceInstanceModel.getServiceId());
                    iServiceInstance.setWeight(iServiceInstanceModel.getWeight().intValue());
                    iServiceInstance.setHost(iServiceInstanceModel.getHost());
                    iServiceInstance.setStatus(iServiceInstanceModel.getStatus().intValue());
                    iServiceInstance.setScheme(iServiceInstanceModel.getScheme());
                    iServiceInstance.setPort(iServiceInstanceModel.getPort().intValue());
                    iServiceInstance.setEnvironment(iServiceInstanceModel.getEnvironment());
                    iServiceInstance.setContext(iServiceInstanceModel.getContext());
                    iServiceInstance.setInstanceId(iServiceInstanceModel.getInstanceId());
                    iServiceInstance.setSecure(iServiceInstanceModel.getSecure());
                    iServiceInstance.setManagerInfo(iServiceInstanceModel.getManagerInfo());
                    instances.add(new IServiceInstanceImpl(iServiceInstance));
                }
            }
        }
        if (instances == null || instances.isEmpty()) {
            throw new JobException(job.getServiceId() + " \u8c03\u5ea6\u5931\u8d25:\u670d\u52a1\u4e0d\u5b58\u5728\u5b9e\u4f8b!");
        }
        return instances;
    }

    protected Result onResult(String jobId, Map<String, Object> res, TaskExecutorService taskExecutor, ServiceInstance instance, Result result) {
        return result.onSuccess(object -> {
            taskExecutor.appendLog(jobId, instance.getInstanceId() + "\u8c03\u5ea6\u6210\u529f\u8fd4\u56de\u503c:" + object);
            res.put(instance.getInstanceId(), object);
        }).onError(e -> {
            res.put(instance.getInstanceId(), "error:" + e.getMessage());
            taskExecutor.appendLog(jobId, instance.getInstanceId() + "\u8c03\u5ea6\u5931\u8d25\u539f\u56e0:" + e.getMessage());
        });
    }
}

