/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.job.actions.dispatch.executor.impl;

import java.util.Map;
import net.risesoft.api.job.JobContext;
import net.risesoft.api.job.TaskExecutorService;
import net.risesoft.api.job.actions.dispatch.ExecutorAction;
import net.risesoft.api.job.actions.dispatch.executor.DoBalance;
import net.risesoft.api.job.actions.dispatch.executor.Result;
import net.risesoft.api.job.actions.dispatch.executor.impl.HttpRequest;
import net.risesoft.api.persistence.model.job.Job;
import net.risesoft.api.persistence.model.job.JobLog;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;

public abstract class HttpExecutorAction
implements ExecutorAction,
DisposableBean,
InitializingBean {
    @Value(value="${beta.job.timeOut:120}")
    private Integer defaultTimeOut;
    @Autowired
    TaskExecutorService taskExecutorService;
    private static RequestConfig defaultRequestConfig;
    private static CloseableHttpAsyncClient httpclient;

    @Override
    public Result action(Job job, JobLog jobLog, Map<String, Object> args, ServiceInstance iServiceInstance, JobContext jobContext, DoBalance doBalance) {
        Object url = iServiceInstance.getUri().toString();
        url = (String)url + job.getSource();
        return this.sendTo((String)url, args, job.getSourceTimeOut() > 0 ? job.getSourceTimeOut() : this.defaultTimeOut);
    }

    abstract HttpRequestBase getRequest(String var1);

    public Result sendTo(String url, Map<String, Object> args, int timeOut) {
        HttpCoreContext context = HttpCoreContext.create();
        args.forEach((k, v) -> context.setAttribute(k, v));
        HttpRequestBase request = this.getRequest(url);
        if (timeOut == 0) {
            request.setConfig(defaultRequestConfig);
        } else {
            request.setConfig(RequestConfig.custom().setSocketTimeout(timeOut * 1000).setConnectTimeout(timeOut * 1000).setConnectionRequestTimeout(timeOut * 1000).build());
        }
        HttpRequest httpRequest = new HttpRequest(url);
        httpclient.execute((HttpUriRequest)request, (HttpContext)context, (FutureCallback)httpRequest);
        return httpRequest;
    }

    public void destroy() throws Exception {
        if (httpclient.isRunning()) {
            httpclient.close();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (!httpclient.isRunning()) {
            httpclient.start();
            defaultRequestConfig = RequestConfig.custom().setSocketTimeout(this.defaultTimeOut * 1000).setConnectTimeout(this.defaultTimeOut * 1000).setConnectionRequestTimeout(this.defaultTimeOut * 1000).build();
        }
    }

    static {
        httpclient = HttpAsyncClients.createDefault();
    }
}

