/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.api.job;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.stereotype.Component;

@Component
public class ScheduledRegister
implements DisposableBean {
    @Autowired
    TaskScheduler taskScheduler;
    private Map<Runnable, ScheduledFuture> futureMap = new ConcurrentHashMap<Runnable, ScheduledFuture>();

    public void addTriggerTask(Runnable task, Trigger trigger) {
        ScheduledFuture future = this.taskScheduler.schedule(task, trigger);
        this.futureMap.put(task, future);
    }

    public boolean removeTask(Runnable task) {
        ScheduledFuture future = this.futureMap.remove(task);
        if (future != null) {
            future.cancel(true);
            return true;
        }
        return false;
    }

    public void destroy() throws Exception {
        this.futureMap.forEach((k, v) -> v.cancel(true));
        this.futureMap.clear();
    }
}

