/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.ProcessParamApi;
import net.risesoft.api.itemadmin.extend.ItemSmsHttpApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.itemadmin.ProcessParamModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.service.SmsRemindService;
import net.risesoft.y9.configuration.app.y9processadmin.Y9ProcessAdminProperties;
import org.apache.commons.lang3.StringUtils;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="smsRemindService")
public class SmsRemindServiceImpl
implements SmsRemindService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SmsRemindServiceImpl.class);
    private final OrgUnitApi orgUnitApi;
    private final PositionApi positionApi;
    private final ProcessParamApi processParamApi;
    private final Y9ProcessAdminProperties y9ProcessAdminProperties;
    private final ItemSmsHttpApi smsHttpApi;

    @Override
    public void smsRemind(DelegateTask task, Map<String, Object> map, Map<String, Object> local) {
        Boolean smsSwitch = this.y9ProcessAdminProperties.getSmsSwitch();
        if (smsSwitch == null || !smsSwitch.booleanValue()) {
            LOGGER.info("######################\u77ed\u4fe1\u63d0\u9192\u5f00\u5173\u5df2\u5173\u95ed,\u5982\u9700\u77ed\u4fe1\u63d0\u9192\u8bf7\u66f4\u6539\u914d\u7f6e\u6587\u4ef6######################");
            return;
        }
        try {
            OrgUnit orgUnit0;
            String assignee = task.getAssignee();
            String tenantId = (String)map.get("tenantId");
            String processInstanceId = task.getProcessInstanceId();
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessInstanceId(tenantId, processInstanceId).getData();
            String isSendSms = processParamModel.getIsSendSms();
            String isShuMing = processParamModel.getIsShuMing();
            Object smsContent = processParamModel.getSmsContent();
            String smsPersonId = processParamModel.getSmsPersonId();
            if (StringUtils.isBlank((CharSequence)isSendSms) || "false".equals(isSendSms)) {
                LOGGER.info("######################\u77ed\u4fe1\u63d0\u9192\u5df2\u53d6\u6d88######################");
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)smsPersonId) && !smsPersonId.contains(assignee)) {
                LOGGER.info("######################\u4e0d\u5728\u6307\u5b9a\u4eba\u5458\u5185\u4e0d\u53d1\u77ed\u4fe1######################");
                return;
            }
            if (local.get("takeBack") != null) {
                return;
            }
            String send = processParamModel.getSended();
            if (StringUtils.isBlank((CharSequence)send) || "false".equals(send)) {
                return;
            }
            ArrayList<String> list = new ArrayList<String>();
            String userId = map.get("taskSenderId").toString();
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
            if ("true".equals(isShuMing)) {
                smsContent = (String)smsContent + "--" + orgUnit.getName();
            }
            if ((orgUnit0 = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, assignee).getData()).getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                List plist = (List)this.positionApi.listPersonsByPositionId(tenantId, assignee).getData();
                for (Person p : plist) {
                    list.add(p.getMobile());
                }
            } else {
                list.add(((Person)orgUnit0).getMobile());
            }
            this.smsHttpApi.sendSmsHttpList(tenantId, userId, list, (String)smsContent, processParamModel.getSystemCnName());
        }
        catch (Exception e) {
            LOGGER.warn("##########################\u77ed\u4fe1\u63d0\u9192\u65f6\u53d1\u751f\u5f02\u5e38-taskId:{}##########################", (Object)task.getId(), (Object)e);
        }
    }

    @Generated
    public SmsRemindServiceImpl(OrgUnitApi orgUnitApi, PositionApi positionApi, ProcessParamApi processParamApi, Y9ProcessAdminProperties y9ProcessAdminProperties, ItemSmsHttpApi smsHttpApi) {
        this.orgUnitApi = orgUnitApi;
        this.positionApi = positionApi;
        this.processParamApi = processParamApi;
        this.y9ProcessAdminProperties = y9ProcessAdminProperties;
        this.smsHttpApi = smsHttpApi;
    }
}

