/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.api.itemadmin.ProcessParamApi;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.itemadmin.ProcessParamModel;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.service.ProcessTaskRelatedService;
import net.risesoft.y9.configuration.app.y9processadmin.Y9ProcessAdminProperties;
import net.risesoft.y9.json.Y9JsonUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang3.StringUtils;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="processTaskRelatedService")
public class ProcessTaskRelatedServiceImpl
implements ProcessTaskRelatedService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessTaskRelatedServiceImpl.class);
    private final OrgUnitApi orgUnitApi;
    private final PositionApi positionApi;
    private final ProcessParamApi processParamApi;
    private final Y9ProcessAdminProperties y9ProcessAdminProperties;

    @Override
    public void execute(DelegateTask task, Map<String, Object> map, Map<String, Object> local) {
        try {
            String tenantId = (String)map.get("tenantId");
            String processSerialNumber = (String)map.get("processSerialNumber");
            ProcessParamModel processParamModel = (ProcessParamModel)this.processParamApi.findByProcessSerialNumber(tenantId, processSerialNumber).getData();
            String documentTitle = processParamModel.getTitle();
            String itemId = processParamModel.getItemId();
            String itemName = processParamModel.getItemName();
            if (local.get("takeBack") != null || local.get("rollBack") != null) {
                return;
            }
            String assignee = task.getAssignee();
            String userId = map.get("taskSenderId").toString();
            String send = processParamModel.getSended();
            if (StringUtils.isBlank((CharSequence)send) || "false".equals(send)) {
                return;
            }
            OrgUnit orgUnit = (OrgUnit)this.orgUnitApi.getOrgUnitPersonOrPosition(tenantId, userId).getData();
            if (orgUnit.getOrgType().equals((Object)OrgTypeEnum.POSITION)) {
                List list = (List)this.positionApi.listPersonsByPositionId(tenantId, assignee).getData();
                String url = this.y9ProcessAdminProperties.getWeiXinUrl();
                for (Person p : list) {
                    try {
                        HttpClient client = new HttpClient();
                        client.getParams().setParameter("http.method.response.buffer.warnlimit", (Object)0xA00000);
                        client.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
                        PostMethod method = new PostMethod();
                        method.addParameter("userId", p.getId());
                        method.addParameter("title", documentTitle);
                        method.addParameter("taskSender", orgUnit.getName());
                        method.addParameter("taskName", itemName + "-" + task.getName());
                        method.addParameter("processSerialNumber", processSerialNumber);
                        method.addParameter("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                        method.addParameter("processInstanceId", task.getProcessInstanceId());
                        method.addParameter("taskId", task.getId());
                        method.addParameter("itemId", itemId);
                        method.setPath(url);
                        int code = client.executeMethod((HttpMethod)method);
                        LOGGER.info("##########################\u5fae\u4fe1\u63a5\u53e3\u72b6\u6001\uff1a{}##########################", (Object)code);
                        if (code != 200) continue;
                        String response = new String(method.getResponseBodyAsString().getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
                        LOGGER.info("##########################\u8fd4\u56de\u72b6\u6001\uff1a{}##########################", (Object)response);
                    }
                    catch (Exception e) {
                        LOGGER.error("##########################\u5fae\u4fe1\u63d0\u9192\u65f6\u53d1\u751f\u5f02\u5e38-userId:{}#", (Object)p.getId());
                    }
                }
            } else {
                HttpClient client = new HttpClient();
                client.getParams().setParameter("http.method.response.buffer.warnlimit", (Object)0xA00000);
                client.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
                PostMethod method = new PostMethod();
                method.addParameter("userId", assignee);
                method.addParameter("title", documentTitle);
                method.addParameter("taskSender", orgUnit.getName());
                method.addParameter("taskName", itemName + "-" + task.getName());
                method.addParameter("processSerialNumber", processSerialNumber);
                method.addParameter("processDefinitionKey", task.getProcessDefinitionId().split(":")[0]);
                method.addParameter("processInstanceId", task.getProcessInstanceId());
                method.addParameter("taskId", task.getId());
                method.addParameter("itemId", itemId);
                String url = this.y9ProcessAdminProperties.getWeiXinUrl();
                method.setPath(url);
                int code = client.executeMethod((HttpMethod)method);
                LOGGER.info("##########################\u5fae\u4fe1\u63a5\u53e3\u72b6\u6001\uff1a{}##########################", (Object)code);
                if (code == 200) {
                    String response = new String(method.getResponseBodyAsString().getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
                    Map m = (Map)Y9JsonUtil.readValue((String)response, Map.class);
                    LOGGER.info("##########################\u8fd4\u56de\u72b6\u6001\uff1a{}##########################", (Object)response);
                    assert (m != null);
                    if ("false".equals(m.get("success"))) {
                        LOGGER.error("##########\u5fae\u4fe1\u63d0\u9192\u5931\u8d25-userId:{}#", (Object)assignee);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("##########################\u5fae\u4fe1\u63d0\u9192\u65f6\u53d1\u751f\u5f02\u5e38-taskId:{} \u9519\u8bef\u4fe1\u606f\uff1a{}###########################", (Object)task.getId(), (Object)e.getMessage());
        }
    }

    @Generated
    public ProcessTaskRelatedServiceImpl(OrgUnitApi orgUnitApi, PositionApi positionApi, ProcessParamApi processParamApi, Y9ProcessAdminProperties y9ProcessAdminProperties) {
        this.orgUnitApi = orgUnitApi;
        this.positionApi = positionApi;
        this.processParamApi = processParamApi;
        this.y9ProcessAdminProperties = y9ProcessAdminProperties;
    }
}

