/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.util.List;
import lombok.Generated;
import net.risesoft.service.ProcessModelService;
import net.risesoft.y9.FlowableTenantInfoHolder;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.engine.RepositoryService;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.springframework.stereotype.Service;

@Service(value="processModelService")
public class ProcessModelServiceImpl
implements ProcessModelService {
    private final ModelService modelService;
    private final RepositoryService repositoryService;

    @Override
    public void copyModel(String sourceTenantId, String targetTenantId, String modelKey) {
        FlowableTenantInfoHolder.setTenantId(sourceTenantId);
        String modelId = null;
        List sourceModelList = this.modelService.getModelsByModelType(Integer.valueOf(0));
        for (AbstractModel aModel : sourceModelList) {
            if (!modelKey.equals(aModel.getKey())) continue;
            modelId = aModel.getId();
            break;
        }
        Model sourceModel = this.modelService.getModel(modelId);
        FlowableTenantInfoHolder.setTenantId(targetTenantId);
        boolean has = false;
        List targetModelList = this.modelService.getModelsByModelType(Integer.valueOf(0));
        for (AbstractModel aModel : targetModelList) {
            if (!modelKey.equals(aModel.getKey())) continue;
            has = true;
            break;
        }
        if (!has) {
            sourceModel.setId(null);
            sourceModel.setTenantId(targetTenantId);
            Model modelData = this.modelService.createModel(sourceModel, "\u7ba1\u7406\u5458");
            BpmnModel bpmnModel = this.modelService.getBpmnModel((AbstractModel)modelData);
            byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(bpmnModel);
            String processName = modelData.getName() + ".bpmn20.xml";
            this.repositoryService.createDeployment().name(modelData.getName()).addBytes(processName, bpmnBytes).deploy();
        }
    }

    @Generated
    public ProcessModelServiceImpl(ModelService modelService, RepositoryService repositoryService) {
        this.modelService = modelService;
        this.repositoryService = repositoryService;
    }
}

