/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.service.CustomProcessDefinitionService;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.runtime.Execution;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"runtimeService", "repositoryService", "historyService", "taskService"})
public class WorkflowTaskService {
    private final RuntimeService runtimeService;
    private final HistoryService historyService;
    private final TaskService taskService;
    private final CustomProcessDefinitionService customProcessDefinitionService;

    public List<String> getActiveTaskDefinitionKeys(String processInstanceId) {
        List<String> taskDefinitionKeyList = new ArrayList<String>();
        List executionList = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        for (Execution execution : executionList) {
            if (execution == null) continue;
            taskDefinitionKeyList = this.runtimeService.getActiveActivityIds(execution.getId());
        }
        return taskDefinitionKeyList;
    }

    public String getActivitiIdByTask(Task task) {
        if (task != null) {
            String excId = task.getExecutionId();
            ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(excId).singleResult();
            return execution.getActivityId();
        }
        return "";
    }

    public String getActivitiIdByTaskId(String taskId) {
        TaskEntity task = this.getTaskByTaskId(taskId);
        return this.getActivitiIdByTask((Task)task);
    }

    public List<Task> getListTaskByCreateTime(Date createTime) {
        return ((TaskQuery)this.taskService.createTaskQuery().taskCreatedOn(createTime)).list();
    }

    public List<HistoricTaskInstance> getParallelTask(String taskId) {
        ArrayList<HistoricTaskInstance> list = new ArrayList<HistoricTaskInstance>();
        try {
            String multinstance;
            TaskEntity currentTask = this.getTaskByTaskId(taskId);
            if (currentTask != null && (multinstance = this.customProcessDefinitionService.getNode(currentTask.getProcessDefinitionId(), currentTask.getTaskDefinitionKey()).getMultiInstance()).equals("parallel")) {
                List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(currentTask.getProcessInstanceId())).taskCreatedOn(currentTask.getCreateTime())).list();
                for (HistoricTaskInstance entity : hisTaskList) {
                    if (entity.getCreateTime().getTime() - currentTask.getCreateTime().getTime() <= -2L || entity.getCreateTime().getTime() - currentTask.getCreateTime().getTime() >= 2L) continue;
                    list.add(entity);
                }
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return list;
        }
    }

    public HistoricTaskInstance getPreviousTask(String taskId) {
        try {
            String taskDefKey = "";
            TaskEntity task = this.getTaskByTaskId(taskId);
            if (task != null) {
                List list;
                if (taskId.equals(task.getId())) {
                    taskDefKey = task.getTaskDefinitionKey();
                }
                if (!(list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).includeTaskLocalVariables()).orderByHistoricTaskInstanceStartTime().desc()).list()).isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)list.get(i);
                        String multiInstance = this.customProcessDefinitionService.getNode(historicTaskInstance.getProcessDefinitionId(), historicTaskInstance.getTaskDefinitionKey()).getMultiInstance();
                        if (multiInstance.equals("parallel")) {
                            Map localMap;
                            String parallelSponsor;
                            if (!StringUtils.isNotBlank((CharSequence)taskDefKey) || taskId.equals(historicTaskInstance.getId()) || -2L > historicTaskInstance.getCreateTime().getTime() - task.getCreateTime().getTime() || historicTaskInstance.getCreateTime().getTime() - task.getCreateTime().getTime() > 2L || !StringUtils.isNotBlank((CharSequence)(parallelSponsor = (String)(localMap = historicTaskInstance.getTaskLocalVariables()).get("parallelSponsor")))) continue;
                            return historicTaskInstance;
                        }
                        if (multiInstance.equals("sequential")) {
                            if (!StringUtils.isNotBlank((CharSequence)taskDefKey)) continue;
                            if (taskDefKey.equals(historicTaskInstance.getTaskDefinitionKey())) {
                                if (historicTaskInstance.getEndTime() == null) continue;
                                return historicTaskInstance;
                            }
                            return historicTaskInstance;
                        }
                        if (taskDefKey.equals(historicTaskInstance.getTaskDefinitionKey())) continue;
                        return historicTaskInstance;
                    }
                }
            } else {
                HistoricTaskInstance histask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
                List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(histask.getProcessInstanceId())).includeTaskLocalVariables()).orderByHistoricTaskInstanceStartTime().desc()).list();
                if (list.size() > 1) {
                    for (int i = 0; i < list.size(); ++i) {
                        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)list.get(i);
                        if (taskId.equals(historicTaskInstance.getId())) {
                            taskDefKey = historicTaskInstance.getTaskDefinitionKey();
                            continue;
                        }
                        if (!StringUtils.isNotBlank((CharSequence)taskDefKey) || taskDefKey.equals(historicTaskInstance.getTaskDefinitionKey())) continue;
                        String multiInstance = this.customProcessDefinitionService.getNode(historicTaskInstance.getProcessDefinitionId(), historicTaskInstance.getTaskDefinitionKey()).getMultiInstance();
                        if (multiInstance.equals("parallel")) {
                            Map localMap = historicTaskInstance.getTaskLocalVariables();
                            String parallelSponsor = (String)localMap.get("parallelSponsor");
                            if (!StringUtils.isNotBlank((CharSequence)parallelSponsor)) continue;
                            return historicTaskInstance;
                        }
                        return historicTaskInstance;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getSendUserId(HistoricTaskInstance historicTaskInstance) {
        String sendUserId = "";
        if (historicTaskInstance != null) {
            sendUserId = historicTaskInstance.getAssignee();
        }
        return sendUserId;
    }

    public String getSendUserId(String taskId) {
        HistoricTaskInstance historicTaskInstance = this.getPreviousTask(taskId);
        return this.getSendUserId(historicTaskInstance);
    }

    public List<Task> getTaskByProcessInstanceId(String processInstanceId) {
        List<Object> list = new ArrayList<Task>();
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            list = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).orderByTaskId()).desc()).list();
        }
        return list;
    }

    public Task getTaskByProcessInstanceIdAndAssgness(String processInstanceId, String assgness) {
        return (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).taskAssignee(assgness)).singleResult();
    }

    public TaskEntity getTaskByTaskId(String taskId) {
        TaskEntity task = null;
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            task = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        }
        return task;
    }

    public String getTaskDefKey(HistoricTaskInstance historicTaskInstance) {
        String taskDefKey = "";
        if (historicTaskInstance != null) {
            taskDefKey = historicTaskInstance.getTaskDefinitionKey();
        }
        return taskDefKey;
    }

    public long getUserTaskCount(String processInstanceId) {
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            return ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).count();
        }
        return -1L;
    }

    public int isHandledParallel(String taskId) {
        List<HistoricTaskInstance> list = this.getParallelTask(taskId);
        if (!list.isEmpty()) {
            int count = 0;
            for (HistoricTaskInstance task : list) {
                if (task.getEndTime() == null) continue;
                ++count;
            }
            if (count > 0) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public String startProUser(String processDefinitionId, String processInstanceId) {
        List list;
        String sendUserId = "";
        if (StringUtils.isNotBlank((CharSequence)processDefinitionId) && StringUtils.isNotBlank((CharSequence)processInstanceId) && (list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processDefinitionId(processDefinitionId)).processInstanceId(processInstanceId)).orderByTaskCreateTime()).asc()).list()) != null && !list.isEmpty()) {
            sendUserId = ((HistoricTaskInstance)list.get(0)).getAssignee();
        }
        return sendUserId;
    }

    public String startTaskDefKey(String processDefinitionId, String processInstanceId) {
        List list;
        String startTaskDefKey = "";
        if (StringUtils.isNotBlank((CharSequence)processDefinitionId) && StringUtils.isNotBlank((CharSequence)processInstanceId) && (list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processDefinitionId(processDefinitionId)).processInstanceId(processInstanceId)).orderByTaskCreateTime()).asc()).list()) != null && !list.isEmpty()) {
            startTaskDefKey = ((HistoricTaskInstance)list.get(0)).getTaskDefinitionKey();
        }
        return startTaskDefKey;
    }

    @Generated
    public WorkflowTaskService(RuntimeService runtimeService, HistoryService historyService, TaskService taskService, CustomProcessDefinitionService customProcessDefinitionService) {
        this.runtimeService = runtimeService;
        this.historyService = historyService;
        this.taskService = taskService;
        this.customProcessDefinitionService = customProcessDefinitionService;
    }
}

