/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.risesoft.service.CustomProcessDefinitionService;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.flowable.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.repository.ProcessDefinitionQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"repositoryService"})
public class WorkflowProcessDefinitionService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowProcessDefinitionService.class);
    private final RepositoryService repositoryService;
    private final CustomProcessDefinitionService customProcessDefinitionService;

    public Map<String, String> getActivityProperties(List<FlowElement> activities, String activityId, List<String> propertiesNameList) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        try {
            for (FlowElement activity : activities) {
                if (!activityId.equals(activity.getId())) continue;
                for (String s : propertiesNameList) {
                    UserTask userTask = (UserTask)activity;
                    Object obj = userTask.getBehavior();
                    if (obj instanceof SequentialMultiInstanceBehavior) {
                        result.put(s, "sequential");
                        continue;
                    }
                    if (obj instanceof ParallelMultiInstanceBehavior) {
                        result.put(s, "parallel");
                        continue;
                    }
                    result.put(s, "");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public Map<String, String> getActivityProperties(String processDefinitionId, String activityId, List<String> propertiesNameList) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        try {
            List<FlowElement> list = this.customProcessDefinitionService.getFlowElements(processDefinitionId);
            return this.getActivityProperties(list, activityId, propertiesNameList);
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public String getActivityProperty(String processDefinitionId, String activityId, String propertyName) {
        Map<Object, Object> map = new HashMap(16);
        ArrayList<String> propertiesNameList = new ArrayList<String>();
        propertiesNameList.add(propertyName);
        try {
            map = this.getActivityProperties(processDefinitionId, activityId, propertiesNameList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (String)map.get(propertyName);
    }

    public List<Map<String, Object>> getBpmList(String processDefinitionId, Boolean isFilter) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<FlowElement> feList = this.customProcessDefinitionService.getFlowElements(processDefinitionId);
        if (isFilter != null && isFilter.booleanValue()) {
            feList.removeIf(fe -> fe instanceof Gateway || fe instanceof StartEvent || fe instanceof EndEvent);
        }
        for (FlowElement activity : feList) {
            LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
            tempMap.put("taskDefKey", activity.getId());
            tempMap.put("taskDefName", activity.getName());
            list.add(tempMap);
        }
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
        tempMap.put("taskDefKey", "");
        tempMap.put("taskDefName", "\u6d41\u7a0b");
        list.add(0, tempMap);
        return list;
    }

    public List<Map<String, Object>> getBpmListContainStart(String processDefinitionId) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<FlowElement> feList = this.customProcessDefinitionService.getFlowElements(processDefinitionId);
        feList.removeIf(activity -> activity instanceof Gateway || activity instanceof EndEvent || activity instanceof SequenceFlow);
        feList.forEach(activity -> {
            LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
            tempMap.put("taskDefKey", activity.getId());
            tempMap.put("taskDefName", activity.getName());
            list.add(tempMap);
        });
        LinkedHashMap<String, String> tempMap = new LinkedHashMap<String, String>();
        tempMap.put("taskDefKey", "");
        tempMap.put("taskDefName", "\u6d41\u7a0b");
        list.add(0, tempMap);
        return list;
    }

    public List<FlowElement> getFilteredActivityImpls(String processDefinitionId, List<String> filterList) {
        ArrayList<FlowElement> list = new ArrayList();
        try {
            list = this.customProcessDefinitionService.getFlowElements(processDefinitionId);
            list.removeIf(activity -> activity instanceof Gateway || filterList.contains(activity.getName()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<String> getProcessDefinitionIds(String processDefinitionKey) {
        ArrayList<String> list = new ArrayList<String>();
        List<ProcessDefinition> processDefinitionList = this.getProcessDefinitions(processDefinitionKey);
        for (ProcessDefinition pd : processDefinitionList) {
            list.add(pd.getId());
        }
        return list;
    }

    public List<ProcessDefinition> getProcessDefinitions(String processDefinitionKey) {
        List<Object> processDefinitionList = new ArrayList<ProcessDefinition>();
        if (StringUtils.isNotBlank((CharSequence)processDefinitionKey)) {
            ProcessDefinitionQuery processDefinitionQuery = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).orderByProcessDefinitionVersion().desc();
            processDefinitionList = processDefinitionQuery.list();
        }
        return processDefinitionList;
    }

    public List<Integer> getProcessDefinitionVersions(String processDefinitionKey) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        List<ProcessDefinition> processDefinitionList = this.getProcessDefinitions(processDefinitionKey);
        for (ProcessDefinition pd : processDefinitionList) {
            list.add(pd.getVersion());
        }
        return list;
    }

    public Map<String, String> procDefIdMap() {
        HashMap<String, String> procDefMap = new HashMap<String, String>(16);
        ProcessDefinitionQuery processDefinitionQuery = (ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByProcessDefinitionKey().asc();
        List processDefinitionList = processDefinitionQuery.list();
        for (ProcessDefinition pd : processDefinitionList) {
            procDefMap.put(pd.getId(), pd.getName());
        }
        return procDefMap;
    }

    @Generated
    public WorkflowProcessDefinitionService(RepositoryService repositoryService, CustomProcessDefinitionService customProcessDefinitionService) {
        this.repositoryService = repositoryService;
        this.customProcessDefinitionService = customProcessDefinitionService;
    }
}

