/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.HistoryService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"runtimeService", "repositoryService", "historyService", "taskService"})
public class WorkflowHistoryProcessInstanceService {
    private final HistoryService historyService;

    public HistoricProcessInstance findOne(String processInstanceId) {
        HistoricProcessInstance historicProcessInstance = null;
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        }
        return historicProcessInstance;
    }

    public List<String> getHierarchySubProcessInstanceIds(String processInstanceId) {
        ArrayList<String> result = new ArrayList<String>();
        List<HistoricProcessInstance> list = this.getHierarchySubProcessInstances(processInstanceId);
        if (list != null) {
            for (HistoricProcessInstance historicProcessInstance : list) {
                result.add(historicProcessInstance.getId());
            }
        }
        return result;
    }

    public List<HistoricProcessInstance> getHierarchySubProcessInstances(String processInstanceId) {
        List<Object> list = new ArrayList<HistoricProcessInstance>();
        if (StringUtils.isNotBlank((CharSequence)processInstanceId) && (list = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstanceId).list()) != null) {
            for (HistoricProcessInstance historicProcessInstance : list) {
                String subProecssInstanceId = historicProcessInstance.getId();
                list.addAll(this.getHierarchySubProcessInstances(subProecssInstanceId));
            }
        }
        return list;
    }

    public List<HistoricProcessInstance> getHierarchySuperProcessInstance(String processInstanceId) {
        HistoricProcessInstance historicProcessInstance;
        ArrayList<HistoricProcessInstance> list = new ArrayList<HistoricProcessInstance>();
        if (StringUtils.isNotBlank((CharSequence)processInstanceId) && (historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()) != null) {
            String superProcessInstanceId = historicProcessInstance.getId();
            list.addAll(this.getHierarchySuperProcessInstance(superProcessInstanceId));
        }
        return list;
    }

    public List<String> getHierarchySuperProcessInstanceId(String processInstanceId) {
        ArrayList<String> result = new ArrayList<String>();
        List<HistoricProcessInstance> list = this.getHierarchySuperProcessInstance(processInstanceId);
        if (list != null) {
            for (HistoricProcessInstance historicProcessInstance : list) {
                result.add(historicProcessInstance.getId());
            }
        }
        return result;
    }

    public List<String> getSubProcessInstanceIds(String processInstanceId) {
        ArrayList<String> result = new ArrayList<String>();
        List<HistoricProcessInstance> list = this.getSubProcessInstances(processInstanceId);
        if (list != null) {
            for (HistoricProcessInstance historicProcessInstance : list) {
                result.add(historicProcessInstance.getId());
            }
        }
        return result;
    }

    public List<HistoricProcessInstance> getSubProcessInstances(String processInstanceId) {
        List<Object> list = new ArrayList<HistoricProcessInstance>();
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            list = this.historyService.createHistoricProcessInstanceQuery().superProcessInstanceId(processInstanceId).list();
        }
        return list;
    }

    public HistoricProcessInstance getSuperProcessInstance(String processInstanceId) {
        HistoricProcessInstance historicProcessInstance = null;
        if (StringUtils.isNotBlank((CharSequence)processInstanceId)) {
            historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        }
        return historicProcessInstance;
    }

    public String getSuperProcessInstanceId(String processInstanceId) {
        HistoricProcessInstance historicProcessInstance = this.getSuperProcessInstance(processInstanceId);
        if (historicProcessInstance != null) {
            return historicProcessInstance.getSuperProcessInstanceId();
        }
        return "";
    }

    @Generated
    public WorkflowHistoryProcessInstanceService(HistoryService historyService) {
        this.historyService = historyService;
    }
}

